/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.AuthenticationException;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.RequestSecurityState;
import org.jboss.seam.security.RunAsOperation;
import org.jboss.seam.security.events.AlreadyLoggedInEvent;
import org.jboss.seam.security.events.DeferredAuthenticationEvent;
import org.jboss.seam.security.events.LoggedInEvent;
import org.jboss.seam.security.events.LoginFailedEvent;
import org.jboss.seam.security.events.NotAuthorizedEvent;
import org.jboss.seam.security.events.NotLoggedInEvent;
import org.jboss.seam.security.events.PostAuthenticateEvent;
import org.jboss.seam.security.events.PostLoggedOutEvent;
import org.jboss.seam.security.events.PreAuthenticateEvent;
import org.jboss.seam.security.events.PreLoggedOutEvent;
import org.jboss.seam.security.events.QuietLoginEvent;
import org.jboss.seam.security.jaas.JaasAuthenticator;
import org.jboss.seam.security.management.IdmAuthenticator;
import org.jboss.seam.security.permission.PermissionMapper;
import org.jboss.seam.security.util.Strings;
import org.jboss.seam.solder.literal.NamedLiteral;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleRole;
import org.picketlink.idm.impl.api.model.SimpleRoleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="identity")
@SessionScoped
public class IdentityImpl
implements Identity,
Serializable {
    private static final long serialVersionUID = 3751659008033189259L;
    private static final String RESPONSE_LOGIN_SUCCESS = "success";
    private static final String RESPONSE_LOGIN_FAILED = "failed";
    private static final String RESPONSE_LOGIN_EXCEPTION = "exception";
    protected static boolean securityEnabled = true;
    Logger log = LoggerFactory.getLogger(IdentityImpl.class);
    @Inject
    BeanManager beanManager;
    @Inject
    private Credentials credentials;
    @Inject
    private PermissionMapper permissionMapper;
    @Inject
    Instance<RequestSecurityState> requestSecurityState;
    @Inject
    @Any
    Instance<Authenticator> authenticators;
    private Authenticator activeAuthenticator;
    private User user;
    private Class<Authenticator> authenticatorClass;
    private String authenticatorName;
    private Map<String, Map<String, List<String>>> preAuthenticationRoles = new HashMap<String, Map<String, List<String>>>();
    private Set<Role> activeRoles = new HashSet<Role>();
    private Map<String, List<String>> preAuthenticationGroups = new HashMap<String, List<String>>();
    private Set<Group> activeGroups = new HashSet<Group>();
    private transient ThreadLocal<Boolean> systemOp;
    private boolean authenticating = false;

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        securityEnabled = enabled;
    }

    @Override
    public boolean isLoggedIn() {
        return this.user != null;
    }

    public Class<Authenticator> getAuthenticatorClass() {
        return this.authenticatorClass;
    }

    public void setAuthenticatorClass(Class<Authenticator> authenticatorClass) {
        this.authenticatorClass = authenticatorClass;
    }

    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    public void setAuthenticatorName(String authenticatorName) {
        this.authenticatorName = authenticatorName;
    }

    @Override
    public boolean tryLogin() {
        if (!this.authenticating && this.getUser() == null && this.credentials.isSet() && !((RequestSecurityState)this.requestSecurityState.get()).isLoginTried()) {
            ((RequestSecurityState)this.requestSecurityState.get()).setLoginTried(true);
            this.quietLogin();
        }
        return this.isLoggedIn();
    }

    @Override
    public String login() {
        try {
            if (this.isLoggedIn()) {
                if (((RequestSecurityState)this.requestSecurityState.get()).isSilentLogin()) {
                    this.beanManager.fireEvent((Object)new LoggedInEvent(this.user), new Annotation[0]);
                    return RESPONSE_LOGIN_SUCCESS;
                }
                this.beanManager.fireEvent((Object)new AlreadyLoggedInEvent(), new Annotation[0]);
                return RESPONSE_LOGIN_SUCCESS;
            }
            boolean success = this.authenticate();
            if (success) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Login successful");
                }
                this.beanManager.fireEvent((Object)new LoggedInEvent(this.user), new Annotation[0]);
                return RESPONSE_LOGIN_SUCCESS;
            }
            this.beanManager.fireEvent((Object)new LoginFailedEvent(null), new Annotation[0]);
            return RESPONSE_LOGIN_FAILED;
        }
        catch (Exception ex) {
            this.log.error("Login failed", (Throwable)ex);
            this.beanManager.fireEvent((Object)new LoginFailedEvent(ex), new Annotation[0]);
            return RESPONSE_LOGIN_EXCEPTION;
        }
    }

    @Override
    public void quietLogin() {
        try {
            this.beanManager.fireEvent((Object)new QuietLoginEvent(), new Annotation[0]);
            if (!this.isLoggedIn() && this.credentials.isSet()) {
                this.authenticate();
                if (this.isLoggedIn()) {
                    ((RequestSecurityState)this.requestSecurityState.get()).setSilentLogin(true);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error authenticating", (Throwable)ex);
            this.credentials.invalidate();
        }
    }

    protected boolean authenticate() throws AuthenticationException {
        if (this.authenticating) {
            this.authenticating = false;
            throw new IllegalStateException("Authentication already in progress.");
        }
        try {
            this.authenticating = true;
            this.user = null;
            this.preAuthenticate();
            this.activeAuthenticator = this.lookupAuthenticator();
            if (this.activeAuthenticator == null) {
                this.authenticating = false;
                throw new AuthenticationException("An Authenticator could not be located");
            }
            this.activeAuthenticator.authenticate();
            switch (this.activeAuthenticator.getStatus()) {
                case SUCCESS: {
                    this.postAuthenticate();
                    return true;
                }
                case FAILURE: {
                    this.authenticating = false;
                    return false;
                }
            }
            return false;
        }
        catch (Exception ex) {
            this.authenticating = false;
            if (ex instanceof AuthenticationException) {
                throw (AuthenticationException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    protected void preAuthenticate() {
        this.preAuthenticationRoles.clear();
        this.beanManager.fireEvent((Object)new PreAuthenticateEvent(), new Annotation[0]);
    }

    protected void deferredAuthenticationObserver(@Observes DeferredAuthenticationEvent event) {
        this.postAuthenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postAuthenticate() {
        if (this.activeAuthenticator == null) {
            throw new IllegalStateException("activeAuthenticator is null");
        }
        try {
            this.activeAuthenticator.postAuthenticate();
            if (!this.activeAuthenticator.getStatus().equals((Object)Authenticator.AuthenticationStatus.SUCCESS)) {
                return;
            }
            this.user = this.activeAuthenticator.getUser();
            if (this.user == null) {
                throw new AuthenticationException("Authenticator must provide a non-null User after successful authentication");
            }
            if (this.isLoggedIn()) {
                if (!this.preAuthenticationRoles.isEmpty()) {
                    for (String group : this.preAuthenticationRoles.keySet()) {
                        Map<String, List<String>> groupTypeRoles = this.preAuthenticationRoles.get(group);
                        for (String groupType : groupTypeRoles.keySet()) {
                            for (String roleType : groupTypeRoles.get(groupType)) {
                                this.addRole(roleType, group, groupType);
                            }
                        }
                    }
                    this.preAuthenticationRoles.clear();
                }
                if (!this.preAuthenticationGroups.isEmpty()) {
                    for (String group : this.preAuthenticationGroups.keySet()) {
                        for (String groupType : this.preAuthenticationGroups.get(group)) {
                            this.activeGroups.add((Group)new SimpleGroup(group, groupType));
                        }
                    }
                    this.preAuthenticationGroups.clear();
                }
            }
            this.beanManager.fireEvent((Object)new PostAuthenticateEvent(), new Annotation[0]);
        }
        finally {
            this.credentials.setCredential(null);
            this.authenticating = false;
        }
    }

    protected Authenticator lookupAuthenticator() throws AuthenticationException {
        if (this.authenticatorClass != null) {
            return (Authenticator)this.authenticators.select(this.authenticatorClass, new Annotation[0]).get();
        }
        if (!Strings.isEmpty(this.authenticatorName)) {
            Instance selected = this.authenticators.select(new Annotation[]{new NamedLiteral(this.authenticatorName)});
            if (selected.isAmbiguous()) {
                this.log.error("Multiple Authenticators found with configured name [" + this.authenticatorName + "]");
                return null;
            }
            if (selected.isUnsatisfied()) {
                this.log.error("No authenticator with name [" + this.authenticatorName + "] was found");
                return null;
            }
            return (Authenticator)selected.get();
        }
        Authenticator selectedAuth = null;
        for (Authenticator auth : this.authenticators) {
            if (!(JaasAuthenticator.class.isAssignableFrom(auth.getClass()) || IdmAuthenticator.class.isAssignableFrom(auth.getClass()) || auth.getClass().getName().startsWith("org.jboss.seam.security.external."))) {
                selectedAuth = auth;
                break;
            }
            if (!IdmAuthenticator.class.isAssignableFrom(auth.getClass())) continue;
            selectedAuth = auth;
        }
        return selectedAuth;
    }

    public void unAuthenticate() {
        this.user = null;
        this.credentials.clear();
        this.preAuthenticationRoles.clear();
        this.activeRoles.clear();
        this.preAuthenticationGroups.clear();
        this.activeGroups.clear();
    }

    @Override
    public void logout() {
        if (this.isLoggedIn()) {
            PostLoggedOutEvent loggedOutEvent = new PostLoggedOutEvent(this.user);
            this.beanManager.fireEvent((Object)new PreLoggedOutEvent(), new Annotation[0]);
            this.unAuthenticate();
            this.beanManager.fireEvent((Object)loggedOutEvent, new Annotation[0]);
        }
    }

    @Override
    public boolean hasRole(String roleType, String group, String groupType) {
        if (!securityEnabled) {
            return true;
        }
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return true;
        }
        this.tryLogin();
        for (Role role : this.activeRoles) {
            if (!role.getRoleType().getName().equals(roleType) || !role.getGroup().getName().equals(group) || !role.getGroup().getGroupType().equals(groupType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRole(String roleType, String group, String groupType) {
        if (roleType == null || "".equals(roleType) || group == null || "".equals(group) || groupType == null || "".equals(groupType)) {
            return false;
        }
        if (this.isLoggedIn()) {
            return this.activeRoles.add((Role)new SimpleRole((RoleType)new SimpleRoleType(roleType), this.user, (Group)new SimpleGroup(group, groupType)));
        }
        List<String> roleTypes = null;
        Map<String, List<String>> groupTypes = this.preAuthenticationRoles.get(group);
        if (groupTypes != null) {
            roleTypes = groupTypes.get(groupType);
        } else {
            groupTypes = new HashMap<String, List<String>>();
            this.preAuthenticationRoles.put(group, groupTypes);
        }
        if (roleTypes == null) {
            roleTypes = new ArrayList<String>();
            groupTypes.put(groupType, roleTypes);
        }
        return roleTypes.add(roleType);
    }

    @Override
    public boolean inGroup(String name, String groupType) {
        for (Group group : this.activeGroups) {
            if (!group.getName().equals(name) || !group.getGroupType().equals(groupType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addGroup(String name, String groupType) {
        if (name == null || "".equals(name) || groupType == null || "".equals(groupType)) {
            return false;
        }
        if (this.isLoggedIn()) {
            return this.activeGroups.add((Group)new SimpleGroup(name, groupType));
        }
        List<Object> groupTypes = null;
        if (this.preAuthenticationGroups.containsKey(name)) {
            groupTypes = this.preAuthenticationGroups.get(name);
        } else {
            groupTypes = new ArrayList();
            this.preAuthenticationGroups.put(name, groupTypes);
        }
        return groupTypes.add(groupType);
    }

    @Override
    public void removeGroup(String name, String groupType) {
        for (Group group : this.activeGroups) {
            if (!group.getName().equals(name) || !group.getGroupType().equals(groupType)) continue;
            this.activeGroups.remove(group);
            return;
        }
    }

    @Override
    public void removeRole(String roleType, String group, String groupType) {
        for (Role role : this.activeRoles) {
            if (!role.getRoleType().getName().equals(roleType) || !role.getGroup().getName().equals(group) || !role.getGroup().getGroupType().equals(groupType)) continue;
            this.activeRoles.remove(role);
            return;
        }
    }

    @Override
    public void checkRole(String roleType, String group, String groupType) {
        this.tryLogin();
        if (!this.hasRole(roleType, group, groupType)) {
            if (!this.isLoggedIn()) {
                this.beanManager.fireEvent((Object)new NotLoggedInEvent(), new Annotation[0]);
                throw new NotLoggedInException();
            }
            this.beanManager.fireEvent((Object)new NotAuthorizedEvent(), new Annotation[0]);
            throw new AuthorizationException(String.format("Authorization check failed for role [%s:%s:%s]", roleType, group, groupType));
        }
    }

    @Override
    public void checkGroup(String group, String groupType) {
        this.tryLogin();
        if (!this.inGroup(group, groupType)) {
            if (!this.isLoggedIn()) {
                this.beanManager.fireEvent((Object)new NotLoggedInEvent(), new Annotation[0]);
                throw new NotLoggedInException();
            }
            this.beanManager.fireEvent((Object)new NotAuthorizedEvent(), new Annotation[0]);
            throw new AuthorizationException(String.format("Authorization check failed for group [%s:%s]", group, groupType));
        }
    }

    @Override
    public void checkPermission(Object target, String action) {
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return;
        }
        this.tryLogin();
        if (!this.hasPermission(target, action)) {
            if (!this.isLoggedIn()) {
                this.beanManager.fireEvent((Object)new NotLoggedInEvent(), new Annotation[0]);
                throw new NotLoggedInException();
            }
            this.beanManager.fireEvent((Object)new NotAuthorizedEvent(), new Annotation[0]);
            throw new AuthorizationException(String.format("Authorization check failed for permission[%s,%s]", target, action));
        }
    }

    @Override
    public void filterByPermission(Collection<?> collection, String action) {
        this.permissionMapper.filterByPermission(collection, action);
    }

    @Override
    public boolean hasPermission(Object target, String action) {
        if (!securityEnabled) {
            return true;
        }
        if (this.systemOp != null && Boolean.TRUE.equals(this.systemOp.get())) {
            return true;
        }
        if (this.permissionMapper == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.permissionMapper.resolvePermission(target, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runAs(RunAsOperation operation) {
        User savedUser = this.getUser();
        if (this.systemOp == null) {
            this.systemOp = new ThreadLocal();
        }
        boolean savedSystemOp = this.systemOp.get();
        try {
            this.user = operation.getUser();
            this.systemOp.set(operation.isSystemOperation());
            operation.execute();
        }
        finally {
            this.systemOp.set(savedSystemOp);
            this.user = savedUser;
        }
    }

    @Override
    public void checkRestriction(String expr) {
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.activeRoles);
    }

    @Override
    public Set<Group> getGroups() {
        return Collections.unmodifiableSet(this.activeGroups);
    }

    @Override
    public boolean isVerified() {
        return false;
    }
}

