/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.events.AlreadyLoggedInEvent;
import org.jboss.seam.security.events.LoggedInEvent;
import org.jboss.seam.security.events.LoginFailedEvent;
import org.jboss.seam.security.events.NotLoggedInEvent;
import org.jboss.seam.security.events.PostAuthenticateEvent;
import org.jboss.solder.core.Requires;

@ApplicationScoped
@Alternative
@Requires(value={"org.jboss.seam.international.status.Messages"})
public class SecurityEventMessages {
    private static final String LOGIN_FAILED_MESSAGE_KEY = "org.jboss.seam.loginFailed";
    private static final String LOGIN_SUCCESSFUL_MESSAGE_KEY = "org.jboss.seam.loginSuccessful";
    private static final String ALREADY_LOGGED_IN_MESSAGE_KEY = "org.jboss.seam.alreadyLoggedIn";
    private static final String NOT_LOGGED_IN_MESSAGE_KEY = "org.jboss.seam.notLoggedIn";
    private static final String DEFAULT_LOGIN_FAILED_MESSAGE = "Login failed.";
    private static final String DEFAULT_LOGIN_SUCCESSFUL_MESSAGE = "Welcome, {0}.";
    private static final String DEFAULT_ALREADY_LOGGED_IN_MESSAGE = "You're already logged in. Please log out first if you wish to log in again.";
    private static final String DEFAULT_NOT_LOGGED_IN_MESSAGE = "Please log in first.";
    @Inject
    Identity identity;
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public void postAuthenticate(@Observes PostAuthenticateEvent event, Messages messages) {
        if (this.enabled) {
            messages.info(DEFAULT_LOGIN_SUCCESSFUL_MESSAGE, new Object[]{this.identity.getUser().getId()});
        }
    }

    public void addLoginFailedMessage(@Observes LoginFailedEvent event) {
    }

    public void addLoginSuccessMessage(@Observes LoggedInEvent event) {
    }

    public void addAlreadyLoggedInMessage(@Observes AlreadyLoggedInEvent event) {
    }

    public void addNotLoggedInMessage(@Observes NotLoggedInEvent event) {
    }

    public String getLoginFailedMessageKey() {
        return LOGIN_FAILED_MESSAGE_KEY;
    }

    public String getDefaultLoginFailedMessage() {
        return DEFAULT_LOGIN_FAILED_MESSAGE;
    }

    public String getLoginSuccessfulMessageKey() {
        return LOGIN_SUCCESSFUL_MESSAGE_KEY;
    }

    public String getDefaultLoginSuccessfulMessage() {
        return DEFAULT_LOGIN_SUCCESSFUL_MESSAGE;
    }

    public String getAlreadyLoggedInMessageKey() {
        return ALREADY_LOGGED_IN_MESSAGE_KEY;
    }

    public String getDefaultAlreadyLoggedInMessage() {
        return DEFAULT_ALREADY_LOGGED_IN_MESSAGE;
    }

    public String getNotLoggedInMessageKey() {
        return NOT_LOGGED_IN_MESSAGE_KEY;
    }

    public String getDefaultNotLoggedInMessage() {
        return DEFAULT_NOT_LOGGED_IN_MESSAGE;
    }
}

