/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.Nonbinding;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.SecurityDefinitionException;
import org.jboss.seam.security.SecurityInterceptorBindingLiteral;
import org.jboss.seam.security.annotations.Secures;
import org.jboss.seam.security.annotations.SecurityBindingType;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.solder.reflection.annotated.InjectableMethod;

public class SecurityExtension
implements Extension {
    private BeanManager beanManager;
    private Set<Authorizer> authorizers = new HashSet<Authorizer>();
    private Set<AnnotatedType<?>> securedTypes = new HashSet();
    private Map<Method, Set<Authorizer>> methodAuthorizers = new HashMap<Method, Set<Authorizer>>();

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        AnnotatedTypeBuilder builder = null;
        AnnotatedType type = event.getAnnotatedType();
        boolean isSecured = false;
        for (Annotation annotation : type.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
            builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass((Annotation)((Object)SecurityInterceptorBindingLiteral.INSTANCE));
            isSecured = true;
        }
        if (!isSecured) {
            block1: for (AnnotatedMethod m : type.getMethods()) {
                if (m.isAnnotationPresent(Secures.class)) {
                    this.registerAuthorizer(m);
                    continue;
                }
                for (Annotation annotation : m.getAnnotations()) {
                    if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
                    if (builder == null) {
                        builder = new AnnotatedTypeBuilder().readFromType(type);
                    }
                    builder.addToMethod(m, (Annotation)((Object)SecurityInterceptorBindingLiteral.INSTANCE));
                    isSecured = true;
                    continue block1;
                }
            }
        }
        if (isSecured) {
            this.securedTypes.add(type);
        }
        if (builder != null) {
            event.setAnnotatedType(builder.create());
        }
    }

    public void validateBindings(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.beanManager = beanManager;
        for (AnnotatedType<?> type : this.securedTypes) {
            for (Annotation annotation : type.getJavaClass().getAnnotations()) {
                boolean found = false;
                if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
                for (Authorizer auth : this.authorizers) {
                    if (!auth.matchesBinding(annotation)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                event.addDefinitionError((Throwable)new SecurityDefinitionException("Secured type " + type.getJavaClass().getName() + " has no matching authorizer method for security binding @" + annotation.annotationType().getName()));
            }
            block3: for (AnnotatedMethod method : type.getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
                    this.registerSecuredMethod(method.getJavaMember());
                    continue block3;
                }
            }
        }
        this.securedTypes.clear();
        this.securedTypes = null;
    }

    public Set<Authorizer> lookupAuthorizerStack(Method m) {
        if (!this.methodAuthorizers.containsKey(m)) {
            this.registerSecuredMethod(m);
        }
        return this.methodAuthorizers.get(m);
    }

    void checkAuthorization(Annotation binding) {
        boolean authorized = false;
        for (Authorizer authorizer : this.authorizers) {
            if (!authorizer.matchesBinding(binding)) continue;
            authorizer.authorize();
            authorized = true;
        }
        if (!authorized) {
            throw new AuthorizationException("Failed to process authorization request - no matching authorizer method for specified binding type [" + binding.annotationType().getClass().getName() + "]");
        }
    }

    protected void registerSecuredMethod(Method method) {
        if (!this.methodAuthorizers.containsKey(method)) {
            HashSet<Annotation> bindings = new HashSet<Annotation>();
            for (Annotation annotation : method.getDeclaringClass().getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
                bindings.add(annotation);
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
                bindings.add(annotation);
            }
            HashSet<Authorizer> authorizerStack = new HashSet<Authorizer>();
            for (Annotation binding : bindings) {
                boolean found = false;
                for (Authorizer authorizer : this.authorizers) {
                    if (!authorizer.matchesBinding(binding)) continue;
                    if (found) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Matching authorizer methods found: [");
                        sb.append(authorizer.getImplementationMethod().getDeclaringClass().getName());
                        sb.append(".");
                        sb.append(authorizer.getImplementationMethod().getName());
                        sb.append("]");
                        for (Authorizer a : authorizerStack) {
                            if (!a.matchesBinding(binding)) continue;
                            sb.append(", [");
                            sb.append(a.getImplementationMethod().getDeclaringClass().getName());
                            sb.append(".");
                            sb.append(a.getImplementationMethod().getName());
                            sb.append("]");
                        }
                        throw new SecurityDefinitionException("Ambiguous authorizers found for security binding type [@" + binding.annotationType().getName() + "] on method [" + method.getDeclaringClass().getName() + "." + method.getName() + "]. " + sb.toString());
                    }
                    authorizerStack.add(authorizer);
                    found = true;
                }
                if (!found) {
                    throw new SecurityDefinitionException("No matching authorizer found for security binding type [@" + binding.annotationType().getName() + "] on method [" + method.getDeclaringClass().getName() + "." + method.getName() + "].");
                }
                this.methodAuthorizers.put(method, authorizerStack);
            }
        }
    }

    protected void registerAuthorizer(AnnotatedMethod<?> m) {
        if (!m.getJavaMember().getReturnType().equals(Boolean.class) && !m.getJavaMember().getReturnType().equals(Boolean.TYPE)) {
            throw new SecurityDefinitionException("Invalid authorizer method [" + m.getJavaMember().getDeclaringClass().getName() + "." + m.getJavaMember().getName() + "] - does not return a boolean.");
        }
        Annotation binding = null;
        for (Annotation a : m.getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
            if (binding != null) {
                throw new SecurityDefinitionException("Invalid authorizer method [" + m.getJavaMember().getDeclaringClass().getName() + "." + m.getJavaMember().getName() + "] - declares multiple security binding types");
            }
            binding = a;
        }
        Authorizer authorizer = new Authorizer(binding, m);
        this.authorizers.add(authorizer);
    }

    class Authorizer {
        private Annotation binding;
        private Map<Method, Object> memberValues = new HashMap<Method, Object>();
        private AnnotatedMethod<?> implementationMethod;
        private Bean<?> targetBean;
        private InjectableMethod<?> injectableMethod;

        public Authorizer(Annotation binding, AnnotatedMethod<?> implementationMethod) {
            this.binding = binding;
            this.implementationMethod = implementationMethod;
            try {
                for (Method m : binding.annotationType().getDeclaredMethods()) {
                    if (m.isAnnotationPresent(Nonbinding.class)) continue;
                    this.memberValues.put(m, m.invoke((Object)binding, new Object[0]));
                }
            }
            catch (InvocationTargetException ex) {
                throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
            }
        }

        public void authorize() {
            if (this.targetBean == null) {
                this.lookupTargetBean();
            }
            CreationalContext cc = SecurityExtension.this.beanManager.createCreationalContext(this.targetBean);
            Object reference = SecurityExtension.this.beanManager.getReference(this.targetBean, this.implementationMethod.getJavaMember().getDeclaringClass(), cc);
            Object result = this.injectableMethod.invoke(reference, cc, null);
            if (result.equals(Boolean.FALSE)) {
                throw new AuthorizationException("Authorization check failed");
            }
        }

        private synchronized void lookupTargetBean() {
            if (this.targetBean == null) {
                Method m = this.implementationMethod.getJavaMember();
                Set beans = SecurityExtension.this.beanManager.getBeans(m.getDeclaringClass(), new Annotation[0]);
                if (beans.size() == 1) {
                    this.targetBean = (Bean)beans.iterator().next();
                } else {
                    if (beans.isEmpty()) {
                        throw new IllegalStateException("Exception looking up authorizer method bean - no beans found for method [" + m.getDeclaringClass() + "." + m.getName() + "]");
                    }
                    if (beans.size() > 1) {
                        throw new IllegalStateException("Exception looking up authorizer method bean - multiple beans found for method [" + m.getDeclaringClass().getName() + "." + m.getName() + "]");
                    }
                }
                this.injectableMethod = new InjectableMethod(this.implementationMethod, this.targetBean, SecurityExtension.this.beanManager);
            }
        }

        public boolean matchesBinding(Annotation annotation) {
            if (!annotation.annotationType().equals(this.binding.annotationType())) {
                return false;
            }
            for (Method m : annotation.annotationType().getDeclaredMethods()) {
                if (m.isAnnotationPresent(Nonbinding.class)) continue;
                if (!this.memberValues.containsKey(m)) {
                    return false;
                }
                try {
                    Object value = m.invoke((Object)annotation, new Object[0]);
                    if (this.memberValues.get(m).equals(value)) continue;
                    return false;
                }
                catch (InvocationTargetException ex) {
                    throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
                }
            }
            return true;
        }

        public Method getImplementationMethod() {
            return this.implementationMethod.getJavaMember();
        }

        public boolean equals(Object value) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

