/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.picketlink;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.security.management.picketlink.IdentityObjectCreatedEvent;
import org.jboss.seam.security.management.picketlink.IdentityStoreConfiguration;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.event.EventListener;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityConfigurationMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityRepositoryConfigurationMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityStoreConfigurationMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityStoreMappingMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.RealmConfigurationMetaDataImpl;
import org.picketlink.idm.impl.repository.WrapperIdentityStoreRepository;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;

@ApplicationScoped
public class IdentitySessionProducer
implements EventListener {
    public static final String SESSION_OPTION_ENTITY_MANAGER = "ENTITY_MANAGER";
    public static final String SESSION_OPTION_IDENTITY_OBJECT_CREATED_EVENT = "IDENTITY_OBJECT_CREATED_EVENT";
    private String defaultRealm = "default";
    private String defaultAttributeStoreId;
    private String defaultIdentityStoreId;
    IdentityConfigurationMetaData metadata;
    @Inject
    BeanManager manager;
    @Inject
    Instance<EntityManager> entityManagerInstance;
    @Inject
    Event<IdentityObjectCreatedEvent> identityObjectCreatedEvent;

    @Inject
    public void init() throws IdentityConfigurationException, IdentityException {
        this.metadata = new IdentityConfigurationMetaDataImpl();
        ArrayList<IdentityStoreConfigurationMetaDataImpl> stores = new ArrayList<IdentityStoreConfigurationMetaDataImpl>();
        String defaultStoreId = null;
        Set storeBeans = this.manager.getBeans(IdentityStoreConfiguration.class, new Annotation[0]);
        for (Bean storeBean : storeBeans) {
            IdentityStoreConfiguration config = (IdentityStoreConfiguration)this.manager.getReference(storeBean, IdentityStoreConfiguration.class, this.manager.createCreationalContext((Contextual)storeBean));
            if (!config.isConfigured()) continue;
            IdentityStoreConfigurationMetaDataImpl storeConfig = new IdentityStoreConfigurationMetaDataImpl();
            config.configure(storeConfig);
            stores.add(storeConfig);
            if (defaultStoreId != null || storeConfig.getId() == null) continue;
            defaultStoreId = storeConfig.getId();
        }
        ((IdentityConfigurationMetaDataImpl)this.metadata).setIdentityStores(stores);
        RealmConfigurationMetaDataImpl realm = new RealmConfigurationMetaDataImpl();
        realm.setId(this.getDefaultRealm());
        realm.setIdentityMapping("USER");
        realm.setOptions(new HashMap());
        ArrayList<RealmConfigurationMetaDataImpl> realms = new ArrayList<RealmConfigurationMetaDataImpl>();
        realms.add(realm);
        ((IdentityConfigurationMetaDataImpl)this.metadata).setRealms(realms);
        if (stores.size() > 0) {
            ArrayList<IdentityRepositoryConfigurationMetaDataImpl> repositories = new ArrayList<IdentityRepositoryConfigurationMetaDataImpl>();
            IdentityRepositoryConfigurationMetaDataImpl repository = new IdentityRepositoryConfigurationMetaDataImpl();
            repository.setClassName(WrapperIdentityStoreRepository.class.getName());
            repository.setDefaultAttributeStoreId(this.defaultAttributeStoreId != null ? this.defaultAttributeStoreId : defaultStoreId);
            repository.setDefaultIdentityStoreId(this.defaultIdentityStoreId != null ? this.defaultIdentityStoreId : defaultStoreId);
            ArrayList<IdentityStoreMappingMetaDataImpl> mappings = new ArrayList<IdentityStoreMappingMetaDataImpl>();
            IdentityStoreMappingMetaDataImpl mapping = new IdentityStoreMappingMetaDataImpl();
            ArrayList<String> identityObjectTypes = new ArrayList<String>();
            identityObjectTypes.add("USER");
            identityObjectTypes.add("GROUP");
            mapping.setIdentityObjectTypeMappings(identityObjectTypes);
            mapping.setIdentityStoreId(this.defaultIdentityStoreId != null ? this.defaultIdentityStoreId : defaultStoreId);
            mappings.add(mapping);
            repository.setIdentityStoreToIdentityObjectTypeMappings(mappings);
            repositories.add(repository);
            ((IdentityConfigurationMetaDataImpl)this.metadata).setRepositories(repositories);
        }
    }

    @Produces
    public IdentitySessionFactory produceFactory() throws IdentityConfigurationException {
        IdentityConfigurationImpl config = new IdentityConfigurationImpl();
        config.configure(this.metadata);
        return config.buildIdentitySessionFactory();
    }

    @Produces
    @RequestScoped
    IdentitySession createIdentitySession(IdentitySessionFactory factory) throws IdentityException {
        if (this.metadata.getRepositories() == null || this.metadata.getRepositories().size() == 0) {
            throw new IdentityException("Error creating IdentitySession - no PicketLink IdentityStore repositories have been configured.");
        }
        HashMap<String, Object> sessionOptions = new HashMap<String, Object>();
        if (!this.entityManagerInstance.isUnsatisfied() && !this.entityManagerInstance.isAmbiguous()) {
            sessionOptions.put(SESSION_OPTION_ENTITY_MANAGER, this.entityManagerInstance.get());
            sessionOptions.put(SESSION_OPTION_IDENTITY_OBJECT_CREATED_EVENT, this.identityObjectCreatedEvent);
        }
        IdentitySession session = factory.createIdentitySession(this.getDefaultRealm(), sessionOptions);
        session.registerListener((EventListener)this);
        return session;
    }

    public String getDefaultRealm() {
        return this.defaultRealm;
    }

    public void setDefaultRealm(String defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public String getDefaultAttributeStoreId() {
        return this.defaultAttributeStoreId;
    }

    public void setDefaultAttributeStoreId(String defaultAttributeStoreId) {
        this.defaultAttributeStoreId = defaultAttributeStoreId;
    }

    public String getDefaultIdentityStoreId() {
        return this.defaultIdentityStoreId;
    }

    public void setDefaultIdentityStoreId(String defaultIdentityStoreId) {
        this.defaultIdentityStoreId = defaultIdentityStoreId;
    }
}

