/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.jboss.seam.security.qualifiers.Security;
import org.jboss.solder.logging.Logger;

public class SecurityRuleProducer {
    private static final Logger log = Logger.getLogger(SecurityRuleProducer.class);
    @Inject
    @org.jboss.solder.resourceLoader.Resource(value="security.drl")
    InputStream securityRules;
    @Inject
    @org.jboss.solder.resourceLoader.Resource(value="WEB-INF/security.drl")
    InputStream webInfSecurityRules;

    @Produces
    @ApplicationScoped
    @Security
    public KnowledgeBase createSecurityKnowledgeBase() {
        KnowledgeBuilderConfiguration config = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBaseConfiguration kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        Resource resource = ResourceFactory.newInputStreamResource((InputStream)(this.securityRules != null ? this.securityRules : this.webInfSecurityRules));
        kbuilder.add(resource, ResourceType.DRL);
        KnowledgeBuilderErrors kbuildererrors = kbuilder.getErrors();
        if (kbuildererrors.size() > 0) {
            for (KnowledgeBuilderError kbuildererror : kbuildererrors) {
                log.error((Object)kbuildererror.getMessage());
            }
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kBaseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

