/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.picketlink;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.jboss.seam.security.annotations.management.IdentityProperty;
import org.jboss.seam.security.annotations.management.PropertyType;
import org.jboss.seam.security.management.IdentityObjectImpl;
import org.jboss.seam.security.management.IdentityObjectRelationshipImpl;
import org.jboss.seam.security.management.IdentityObjectRelationshipTypeImpl;
import org.jboss.seam.security.management.IdentityObjectTypeImpl;
import org.jboss.seam.security.management.picketlink.IdentityObjectCreatedEvent;
import org.jboss.seam.security.management.picketlink.JpaIdentityStoreSessionImpl;
import org.jboss.solder.properties.Property;
import org.jboss.solder.properties.query.AnnotatedPropertyCriteria;
import org.jboss.solder.properties.query.NamedPropertyCriteria;
import org.jboss.solder.properties.query.PropertyCriteria;
import org.jboss.solder.properties.query.PropertyQueries;
import org.jboss.solder.properties.query.TypedPropertyCriteria;
import org.jboss.solder.reflection.Reflections;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.store.FeaturesMetaDataImpl;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class JpaIdentityStore
implements IdentityStore,
Serializable {
    private static final long serialVersionUID = 7729139146633529501L;
    public static final String OPTION_IDENTITY_CLASS_NAME = "identityEntityClassName";
    public static final String OPTION_CREDENTIAL_CLASS_NAME = "credentialEntityClassName";
    public static final String OPTION_RELATIONSHIP_CLASS_NAME = "relationshipEntityClassName";
    public static final String OPTION_ROLE_TYPE_CLASS_NAME = "roleTypeEntityClassName";
    public static final String OPTION_ATTRIBUTE_CLASS_NAME = "attributeEntityClassName";
    private static final String DEFAULT_USER_IDENTITY_TYPE = "USER";
    private static final String DEFAULT_ROLE_IDENTITY_TYPE = "ROLE";
    private static final String DEFAULT_GROUP_IDENTITY_TYPE = "GROUP";
    private static final String DEFAULT_RELATIONSHIP_TYPE_MEMBERSHIP = "MEMBERSHIP";
    private static final String DEFAULT_RELATIONSHIP_TYPE_ROLE = "ROLE";
    private static final String PROPERTY_IDENTITY_ID = "IDENTITY_ID";
    private static final String PROPERTY_IDENTITY_NAME = "IDENTITY_NAME";
    private static final String PROPERTY_IDENTITY_TYPE = "IDENTITY_TYPE";
    private static final String PROPERTY_IDENTITY_TYPE_NAME = "IDENTITY_TYPE_NAME";
    private static final String PROPERTY_CREDENTIAL_VALUE = "CREDENTIAL_VALUE";
    private static final String PROPERTY_CREDENTIAL_TYPE = "CREDENTIAL_TYPE";
    private static final String PROPERTY_CREDENTIAL_TYPE_NAME = "CREDENTIAL_TYPE_NAME";
    private static final String PROPERTY_CREDENTIAL_IDENTITY = "CREDENTIAL_IDENTITY";
    private static final String PROPERTY_RELATIONSHIP_FROM = "RELATIONSHIP_FROM";
    private static final String PROPERTY_RELATIONSHIP_TO = "RELATIONSHIP_TO";
    private static final String PROPERTY_RELATIONSHIP_TYPE = "RELATIONSHIP_TYPE";
    private static final String PROPERTY_RELATIONSHIP_TYPE_NAME = "RELATIONSHIP_TYPE_NAME";
    private static final String PROPERTY_RELATIONSHIP_NAME = "RELATIONSHIP_NAME";
    private static final String PROPERTY_ROLE_TYPE_NAME = "RELATIONSHIP_NAME_NAME";
    private static final String PROPERTY_ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    private static final String PROPERTY_ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    private static final String PROPERTY_ATTRIBUTE_IDENTITY = "ATTRIBUTE_IDENTITY";
    private static final String PROPERTY_ATTRIBUTE_TYPE = "ATTRIBUTE_TYPE";
    private static final String ATTRIBUTE_TYPE_TEXT = "text";
    private static final String ATTRIBUTE_TYPE_BOOLEAN = "boolean";
    private static final String ATTRIBUTE_TYPE_DATE = "date";
    private static final String ATTRIBUTE_TYPE_INT = "int";
    private static final String ATTRIBUTE_TYPE_LONG = "long";
    private static final String ATTRIBUTE_TYPE_FLOAT = "float";
    private static final String ATTRIBUTE_TYPE_DOUBLE = "double";
    private String id;
    private Class<?> identityClass;
    private Class<?> credentialClass;
    private Class<?> relationshipClass;
    private Class<?> attributeClass;
    private Class<?> roleTypeClass;
    private String userIdentityType = "USER";
    private String roleIdentityType = "ROLE";
    private String groupIdentityType = "GROUP";
    private String relationshipTypeMembership = "MEMBERSHIP";
    private String relationshipTypeRole = "ROLE";
    private Map<String, Property<Object>> modelProperties = new HashMap<String, Property<Object>>();
    private Map<String, MappedAttribute> attributeProperties = new HashMap<String, MappedAttribute>();
    boolean namedRelationshipsSupported = false;
    private FeaturesMetaData featuresMetaData;

    public JpaIdentityStore(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String clsName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(OPTION_IDENTITY_CLASS_NAME);
        if (clsName == null) {
            throw new IdentityException("Error bootstrapping JpaIdentityStore - identity entity class cannot be null");
        }
        try {
            this.identityClass = Reflections.classForName((String)clsName, (ClassLoader[])new ClassLoader[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IdentityException("Error bootstrapping JpaIdentityStore - invalid identity entity class: " + clsName);
        }
        if (this.identityClass == null) {
            throw new IdentityException("Error initializing JpaIdentityStore - identityClass not set");
        }
        clsName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(OPTION_CREDENTIAL_CLASS_NAME);
        if (clsName != null) {
            try {
                this.credentialClass = Class.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Error bootstrapping JpaIdentityStore - invalid credential entity class: " + clsName);
            }
        }
        clsName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(OPTION_RELATIONSHIP_CLASS_NAME);
        try {
            this.relationshipClass = Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new IdentityException("Error bootstrapping JpaIdentityStore - invalid relationship entity class: " + clsName);
        }
        clsName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(OPTION_ROLE_TYPE_CLASS_NAME);
        if (clsName != null) {
            try {
                this.roleTypeClass = Class.forName(clsName);
                this.namedRelationshipsSupported = true;
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Error bootstrapping JpaIdentityStore - invalid role type entity class: " + clsName);
            }
        }
        if ((clsName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(OPTION_ATTRIBUTE_CLASS_NAME)) != null) {
            try {
                this.attributeClass = Class.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Error bootstrapping JpaIdentityStore - invalid attribute entity class: " + clsName);
            }
        }
        this.configureIdentityId();
        this.configureIdentityName();
        this.configureIdentityType();
        this.configureCredentials();
        this.configureRelationships();
        this.configureAttributes();
        if (this.namedRelationshipsSupported) {
            this.configureRoleTypeName();
        }
        this.featuresMetaData = new FeaturesMetaDataImpl(configurationContext.getStoreConfigurationMetaData(), new HashSet(), false, this.namedRelationshipsSupported, new HashSet());
    }

    protected void configureIdentityId() throws IdentityException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Id.class)).getResultList();
        if (props.size() != 1) {
            throw new IdentityException("Error initializing JpaIdentityStore - no Identity ID found.");
        }
        this.modelProperties.put(PROPERTY_IDENTITY_ID, (Property<Object>)props.get(0));
    }

    protected void configureIdentityName() throws IdentityException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_NAME, (Property<Object>)props.get(0));
        } else {
            if (props.size() > 1) {
                throw new IdentityException("Ambiguous identity name property in identity class " + this.identityClass.getName());
            }
            Property<Object> p = this.findNamedProperty(this.identityClass, "username", "userName", "name");
            if (p != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_NAME, p);
            } else {
                props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).getResultList();
                if (props.size() == 1) {
                    this.modelProperties.put(PROPERTY_IDENTITY_NAME, (Property<Object>)props.get(0));
                }
            }
        }
        if (!this.modelProperties.containsKey(PROPERTY_IDENTITY_NAME)) {
            throw new IdentityException("Error initializing JpaIdentityStore - no valid identity name property found.");
        }
    }

    protected void configureIdentityType() throws IdentityException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.TYPE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_TYPE, (Property<Object>)props.get(0));
        } else {
            if (props.size() > 1) {
                throw new IdentityException("Ambiguous identity type property in identity class " + this.identityClass.getName());
            }
            Property<Object> p = this.findNamedProperty(this.identityClass, "identityObjectType", "identityType", "identityObjectTypeName", "identityTypeName", "typeName", "discriminator", "accountType", "userType", "type");
            if (p != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_TYPE, (Property<Object>)props.get(0));
            } else {
                props = PropertyQueries.createQuery(this.identityClass).getResultList();
                for (Property typeProp : props) {
                    Property<Object> nameProp;
                    if (!typeProp.getJavaClass().isAnnotationPresent(Entity.class) || !typeProp.getJavaClass().getSimpleName().contains("type") && !typeProp.getJavaClass().getSimpleName().contains("Type") || (nameProp = this.findNamedProperty(typeProp.getJavaClass(), "identityObjectTypeName", "identityTypeName", "typeName", "name")) == null) continue;
                    this.modelProperties.put(PROPERTY_IDENTITY_TYPE, (Property<Object>)typeProp);
                    this.modelProperties.put(PROPERTY_IDENTITY_TYPE_NAME, nameProp);
                    break;
                }
            }
        }
        Property<Object> typeProp = this.modelProperties.get(PROPERTY_IDENTITY_TYPE);
        if (typeProp == null) {
            throw new IdentityException("Error initializing JpaIdentityStore - no valid identity type property found.");
        }
        if (!String.class.equals((Object)typeProp.getJavaClass()) && !this.modelProperties.containsKey(PROPERTY_IDENTITY_TYPE_NAME)) {
            Property<Object> nameProp = this.findNamedProperty(typeProp.getJavaClass(), "identityObjectTypeName", "identityTypeName", "typeName", "name");
            if (nameProp != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_TYPE_NAME, nameProp);
            } else {
                throw new IdentityException("Error initializing JpaIdentityStore - no valid identity type name property found.");
            }
        }
    }

    protected Property<Object> findNamedProperty(Class<?> targetClass, String ... allowedNames) {
        List props = PropertyQueries.createQuery(targetClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.NAME)).getResultList();
        if (props.size() == 1) {
            return (Property)props.get(0);
        }
        props = PropertyQueries.createQuery(targetClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).addCriteria((PropertyCriteria)new NamedPropertyCriteria(allowedNames)).getResultList();
        for (String name : allowedNames) {
            for (Property prop : props) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void configureCredentials() throws IdentityException {
        Property<Object> typeProp;
        Property<Object> p;
        List props;
        if (this.credentialClass != null) {
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.VALUE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_CREDENTIAL_VALUE, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous credential value property in credential class " + this.credentialClass.getName());
                }
                props = PropertyQueries.createQuery(this.credentialClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.CREDENTIAL)).getResultList();
                if (props.size() == 1) {
                    this.modelProperties.put(PROPERTY_CREDENTIAL_VALUE, (Property<Object>)props.get(0));
                } else {
                    if (props.size() > 1) {
                        throw new IdentityException("Ambiguous credential value property in credential class " + this.credentialClass.getName());
                    }
                    p = this.findNamedProperty(this.credentialClass, "credentialValue", "password", "passwordHash", "credential", "value");
                    if (p != null) {
                        this.modelProperties.put(PROPERTY_CREDENTIAL_VALUE, p);
                    }
                }
            }
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(this.identityClass)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_CREDENTIAL_IDENTITY, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous identity property in credential class " + this.credentialClass.getName());
                }
                props = PropertyQueries.createQuery(this.credentialClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{"identity", "identityObject"})).getResultList();
                if (props.isEmpty()) throw new IdentityException("Error initializing JpaIdentityStore - no credential identity property found.");
                this.modelProperties.put(PROPERTY_CREDENTIAL_IDENTITY, (Property<Object>)props.get(0));
            }
        } else {
            props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.CREDENTIAL)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_CREDENTIAL_VALUE, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous credential property in identity class " + this.identityClass.getName());
                }
                p = this.findNamedProperty(this.identityClass, "credentialValue", "password", "passwordHash", "credential", "value");
                if (p != null) {
                    this.modelProperties.put(PROPERTY_CREDENTIAL_VALUE, p);
                }
            }
            props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.CREDENTIAL_TYPE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous credential type property in identity class " + this.identityClass.getName());
                }
                p = this.findNamedProperty(this.identityClass, "credentialType", "identityObjectCredentialType", "type");
                if (p != null) {
                    this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE, p);
                }
            }
        }
        if (!this.modelProperties.containsKey(PROPERTY_CREDENTIAL_VALUE)) {
            throw new IdentityException("Error initializing JpaIdentityStore - no credential value property found.");
        }
        if (this.modelProperties.get(PROPERTY_CREDENTIAL_TYPE) == null) {
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.TYPE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous credential type property in credential class " + this.credentialClass.getName());
                }
                props = PropertyQueries.createQuery(this.credentialClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.CREDENTIAL_TYPE)).getResultList();
                if (props.size() == 1) {
                    this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE, (Property<Object>)props.get(0));
                } else {
                    if (props.size() > 1) {
                        throw new IdentityException("Ambiguous credential type property in credential class " + this.credentialClass.getName());
                    }
                    p = this.findNamedProperty(this.credentialClass, "credentialType", "identityObjectCredentialType", "type");
                    if (p != null) {
                        this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE, p);
                    }
                }
            }
        }
        if (String.class.equals((Object)(typeProp = this.modelProperties.get(PROPERTY_CREDENTIAL_TYPE)).getJavaClass())) return;
        Property<Object> nameProp = this.findNamedProperty(typeProp.getJavaClass(), "credentialObjectTypeName", "credentialTypeName", "typeName", "name");
        if (nameProp == null) throw new IdentityException("Error initializing JpaIdentityStore - no valid credential type name property found.");
        this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE_NAME, nameProp);
    }

    protected void configureRelationships() throws IdentityException {
        Property<Object> p;
        if (this.relationshipClass == null) {
            throw new IdentityException("Error initializing JpaIdentityStore - relationshipClass not set.");
        }
        List props = PropertyQueries.createQuery(this.relationshipClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(this.identityClass)).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.RELATIONSHIP_FROM)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_RELATIONSHIP_FROM, (Property<Object>)props.get(0));
        } else {
            if (props.size() > 1) {
                throw new IdentityException("Ambiguous relationshipFrom property in relationship class " + this.relationshipClass.getName());
            }
            p = this.findNamedProperty(this.relationshipClass, "relationshipFrom", "fromIdentityObject", "fromIdentity");
            if (p != null) {
                this.modelProperties.put(PROPERTY_RELATIONSHIP_FROM, p);
            } else {
                props = PropertyQueries.createQuery(this.relationshipClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(this.identityClass)).getResultList();
                for (Property prop : props) {
                    if (!prop.getName().contains("from")) continue;
                    this.modelProperties.put(PROPERTY_RELATIONSHIP_FROM, (Property<Object>)prop);
                    break;
                }
            }
        }
        props = PropertyQueries.createQuery(this.relationshipClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(this.identityClass)).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.RELATIONSHIP_TO)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_RELATIONSHIP_TO, (Property<Object>)props.get(0));
        } else {
            if (props.size() > 1) {
                throw new IdentityException("Ambiguous relationshipTo property in relationship class " + this.relationshipClass.getName());
            }
            p = this.findNamedProperty(this.relationshipClass, "relationshipTo", "toIdentityObject", "toIdentity");
            if (p != null) {
                this.modelProperties.put(PROPERTY_RELATIONSHIP_TO, p);
            } else {
                props = PropertyQueries.createQuery(this.relationshipClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(this.identityClass)).getResultList();
                for (Property prop : props) {
                    if (!prop.getName().contains("to")) continue;
                    this.modelProperties.put(PROPERTY_RELATIONSHIP_TO, (Property<Object>)prop);
                    break;
                }
            }
        }
        props = PropertyQueries.createQuery(this.relationshipClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.TYPE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_RELATIONSHIP_TYPE, (Property<Object>)props.get(0));
        } else {
            if (props.size() > 1) {
                throw new IdentityException("Ambiguous relationshipType property in relationship class " + this.relationshipClass.getName());
            }
            p = this.findNamedProperty(this.relationshipClass, "identityRelationshipType", "relationshipType", "type");
            if (p != null) {
                this.modelProperties.put(PROPERTY_RELATIONSHIP_TYPE, p);
            } else {
                props = PropertyQueries.createQuery(this.relationshipClass).getResultList();
                for (Property prop : props) {
                    if (!prop.getName().contains("type")) continue;
                    this.modelProperties.put(PROPERTY_RELATIONSHIP_TYPE, (Property<Object>)prop);
                    break;
                }
            }
        }
        props = PropertyQueries.createQuery(this.relationshipClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.NAME)).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_RELATIONSHIP_NAME, (Property<Object>)props.get(0));
        } else {
            if (props.size() > 1) {
                throw new IdentityException("Ambiguous relationship name property in relationship class " + this.relationshipClass.getName());
            }
            p = this.findNamedProperty(this.relationshipClass, "relationshipName", "name");
            if (p != null) {
                this.modelProperties.put(PROPERTY_RELATIONSHIP_NAME, p);
            }
        }
        if (this.modelProperties.containsKey(PROPERTY_RELATIONSHIP_NAME)) {
            this.namedRelationshipsSupported = true;
        }
        if (!this.modelProperties.containsKey(PROPERTY_RELATIONSHIP_FROM)) {
            throw new IdentityException("Error initializing JpaIdentityStore - no valid relationship from property found.");
        }
        if (!this.modelProperties.containsKey(PROPERTY_RELATIONSHIP_TO)) {
            throw new IdentityException("Error initializing JpaIdentityStore - no valid relationship to property found.");
        }
        if (!this.modelProperties.containsKey(PROPERTY_RELATIONSHIP_TYPE)) {
            throw new IdentityException("Error initializing JpaIdentityStore - no valid relationship type property found.");
        }
        if (!this.modelProperties.containsKey(PROPERTY_RELATIONSHIP_NAME)) {
            throw new IdentityException("Error initializing JpaIdentityStore - no valid relationship name property found.");
        }
        Class typeClass = this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE).getJavaClass();
        if (!String.class.equals((Object)typeClass)) {
            props = PropertyQueries.createQuery((Class)typeClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.NAME)).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_RELATIONSHIP_TYPE_NAME, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous relationship type name property in class " + typeClass.getName());
                }
                Property<Object> p2 = this.findNamedProperty(typeClass, "relationshipTypeName", "typeName", "name");
                if (p2 != null) {
                    this.modelProperties.put(PROPERTY_RELATIONSHIP_TYPE_NAME, p2);
                }
            }
            if (!this.modelProperties.containsKey(PROPERTY_RELATIONSHIP_TYPE_NAME)) {
                throw new IdentityException("Error initializing JpaIdentityStore - no valid relationship type name property found");
            }
        }
    }

    protected void configureAttributes() throws IdentityException {
        List props;
        if (this.attributeClass != null) {
            Property<Object> prop;
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.NAME)).addCriteria((PropertyCriteria)new TypedPropertyCriteria(String.class)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_NAME, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous attribute name property in class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeName", "name");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_NAME, prop);
                }
            }
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.VALUE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_VALUE, (Property<Object>)props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous attribute value property in class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeValue", "value");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_VALUE, prop);
                }
            }
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(this.identityClass)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new IdentityException("Ambiguous identity property in attribute class " + this.attributeClass.getName());
                }
                throw new IdentityException("Error initializing JpaIdentityStore - no attribute identity property found.");
            }
            this.modelProperties.put(PROPERTY_ATTRIBUTE_IDENTITY, (Property<Object>)props.get(0));
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.TYPE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_TYPE, (Property<Object>)props.get(0));
            } else if (props.size() > 1) {
                throw new IdentityException("Ambiguous attribute type property in class " + this.attributeClass.getName());
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.ATTRIBUTE)).getResultList();
        for (Property p : props) {
            String attribName = p.getAnnotatedElement().getAnnotation(IdentityProperty.class).attributeName();
            if (this.attributeProperties.containsKey(attribName)) {
                Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                throw new IdentityException("Multiple properties defined for attribute [" + attribName + "] - " + "Property: " + other.getDeclaringClass().getName() + "." + other.getAnnotatedElement().toString() + ", Property: " + p.getDeclaringClass().getName() + "." + p.getAnnotatedElement().toString());
            }
            this.attributeProperties.put(attribName, new MappedAttribute(null, (Property<Object>)p));
        }
        props = PropertyQueries.createQuery(this.identityClass).getResultList();
        for (Property p : props) {
            if (p.isReadOnly() || !p.getJavaClass().isAnnotationPresent(Entity.class)) continue;
            List pp = PropertyQueries.createQuery((Class)p.getJavaClass()).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PropertyType.ATTRIBUTE)).getResultList();
            for (Property attributeProperty : pp) {
                String attribName = attributeProperty.getAnnotatedElement().getAnnotation(IdentityProperty.class).attributeName();
                if (this.attributeProperties.containsKey(attribName)) {
                    Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                    throw new IdentityException("Multiple properties defined for attribute [" + attribName + "] - " + "Property: " + other.getDeclaringClass().getName() + "." + other.getAnnotatedElement().toString() + ", Property: " + attributeProperty.getDeclaringClass().getName() + "." + attributeProperty.getAnnotatedElement().toString());
                }
                this.attributeProperties.put(attribName, new MappedAttribute((Property<Object>)p, (Property<Object>)attributeProperty));
            }
        }
    }

    protected void configureRoleTypeName() {
        Property<Object> relationshipNameProp = this.findNamedProperty(this.roleTypeClass, "name");
        if (relationshipNameProp != null) {
            this.modelProperties.put(PROPERTY_ROLE_TYPE_NAME, relationshipNameProp);
        }
    }

    public String getUserIdentityType() {
        return this.userIdentityType;
    }

    public void setUserIdentityType(String userIdentityType) {
        this.userIdentityType = userIdentityType;
    }

    public String getRoleIdentityType() {
        return this.roleIdentityType;
    }

    public void setRoleIdentityType(String roleIdentityType) {
        this.roleIdentityType = roleIdentityType;
    }

    public String getGroupIdentityType() {
        return this.groupIdentityType;
    }

    public void setGroupIdentityType(String groupIdentityType) {
        this.groupIdentityType = groupIdentityType;
    }

    public String getRelationshipTypeMembership() {
        return this.relationshipTypeMembership;
    }

    public void setRelationshipTypeMembership(String relationshipTypeMembership) {
        this.relationshipTypeMembership = relationshipTypeMembership;
    }

    public String getRelationshipTypeRole() {
        return this.relationshipTypeRole;
    }

    public void setRelationshipTypeRole(String relationshipTypeRole) {
        this.relationshipTypeRole = relationshipTypeRole;
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        EntityManager em = (EntityManager)sessionOptions.get("ENTITY_MANAGER");
        Event event = (Event)sessionOptions.get("IDENTITY_OBJECT_CREATED_EVENT");
        return new JpaIdentityStoreSessionImpl(em, (Event<IdentityObjectCreatedEvent>)event);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    protected Object lookupIdentityType(String identityType, EntityManager em) {
        Property<Object> typeNameProp = this.modelProperties.get(PROPERTY_IDENTITY_TYPE_NAME);
        try {
            if (typeNameProp == null) {
                return identityType;
            }
            Object val = em.createQuery("select t from " + typeNameProp.getDeclaringClass().getSimpleName() + " t where t." + typeNameProp.getName() + " = :identityType").setParameter("identityType", (Object)identityType).getSingleResult();
            return val;
        }
        catch (NoResultException ex) {
            try {
                Object instance = typeNameProp.getDeclaringClass().newInstance();
                typeNameProp.setValue(instance, (Object)identityType);
                em.persist(instance);
                return instance;
            }
            catch (Exception ex2) {
                throw new RuntimeException("Error creating identity type", ex2);
            }
        }
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        try {
            Object id;
            Object identityInstance = this.identityClass.newInstance();
            this.modelProperties.get(PROPERTY_IDENTITY_NAME).setValue(identityInstance, (Object)name);
            Property<Object> typeProp = this.modelProperties.get(PROPERTY_IDENTITY_TYPE);
            if (String.class.equals((Object)typeProp.getJavaClass())) {
                typeProp.setValue(identityInstance, (Object)identityObjectType.getName());
            } else {
                typeProp.setValue(identityInstance, this.lookupIdentityType(identityObjectType.getName(), this.getEntityManager(ctx)));
            }
            EntityManager em = this.getEntityManager(ctx);
            for (String attribName : this.attributeProperties.keySet()) {
                MappedAttribute attrib = this.attributeProperties.get(attribName);
                if (attrib.getIdentityProperty() == null || attrib.getIdentityProperty().getValue(identityInstance) != null) continue;
                Object instance = attrib.getIdentityProperty().getJavaClass().newInstance();
                attrib.getIdentityProperty().setValue(identityInstance, instance);
                em.persist(instance);
            }
            em.persist(identityInstance);
            Event<IdentityObjectCreatedEvent> event = ((JpaIdentityStoreSessionImpl)ctx.getIdentityStoreSession()).getIdentityObjectCreatedEvent();
            if (event != null) {
                event.fire((Object)new IdentityObjectCreatedEvent(identityInstance));
            }
            IdentityObjectImpl obj = new IdentityObjectImpl((id = this.modelProperties.get(PROPERTY_IDENTITY_ID).getValue(identityInstance)) != null ? id.toString() : null, name, identityObjectType);
            if (attributes != null) {
                ArrayList<SimpleAttribute> attribs = new ArrayList<SimpleAttribute>();
                for (String key : attributes.keySet()) {
                    for (String value : attributes.get(key)) {
                        attribs.add(new SimpleAttribute(key, (Object)value));
                    }
                }
                this.updateAttributes(ctx, obj, attribs.toArray(new IdentityObjectAttribute[attribs.size()]));
            }
            em.flush();
            return obj;
        }
        catch (Exception ex) {
            throw new IdentityException("Error creating identity object", (Throwable)ex);
        }
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCtx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        try {
            EntityManager em = this.getEntityManager(invocationCtx);
            Object relationship = this.relationshipClass.newInstance();
            this.modelProperties.get(PROPERTY_RELATIONSHIP_FROM).setValue(relationship, this.lookupIdentity(fromIdentity, em));
            this.modelProperties.get(PROPERTY_RELATIONSHIP_TO).setValue(relationship, this.lookupIdentity(toIdentity, em));
            Property<Object> type = this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE);
            if (String.class.equals((Object)this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE).getJavaClass())) {
                type.setValue(relationship, (Object)relationshipType.getName());
            } else {
                type.setValue(relationship, this.lookupRelationshipType(relationshipType, em));
            }
            this.modelProperties.get(PROPERTY_RELATIONSHIP_NAME).setValue(relationship, (Object)relationshipName);
            em.persist(relationship);
            em.flush();
            return new IdentityObjectRelationshipImpl(fromIdentity, toIdentity, relationshipName, relationshipType);
        }
        catch (Exception ex) {
            throw new IdentityException("Exception creating relationship", (Throwable)ex);
        }
    }

    protected Object lookupIdentity(IdentityObject obj, EntityManager em) {
        Property<Object> identityNameProp = this.modelProperties.get(PROPERTY_IDENTITY_NAME);
        Property<Object> identityTypeProp = this.modelProperties.get(PROPERTY_IDENTITY_TYPE);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.identityClass);
        Root root = criteria.from(this.identityClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityNameProp.getName()), (Object)obj.getName()));
        predicates.add(builder.equal((Expression)root.get(identityTypeProp.getName()), this.lookupIdentityType(obj.getIdentityType().getName(), em)));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getSingleResult();
    }

    protected Object lookupCredentialTypeEntity(String name, EntityManager em) {
        Property<Object> credentialTypeNameProp = this.modelProperties.get(PROPERTY_CREDENTIAL_TYPE_NAME);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(credentialTypeNameProp.getDeclaringClass());
        Root root = criteria.from(credentialTypeNameProp.getDeclaringClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(credentialTypeNameProp.getName()), (Object)name));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getSingleResult();
    }

    protected Object lookupRelationshipType(IdentityObjectRelationshipType relationshipType, EntityManager em) {
        Property<Object> relationshipTypeNameProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE_NAME);
        if (relationshipTypeNameProp != null) {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(relationshipTypeNameProp.getDeclaringClass());
            Root root = criteria.from(relationshipTypeNameProp.getDeclaringClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(relationshipTypeNameProp.getName()), (Object)relationshipType.getName()));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            return em.createQuery(criteria).getSingleResult();
        }
        return relationshipType.getName();
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        try {
            Property<Object> roleTypeNameProp = this.modelProperties.get(PROPERTY_ROLE_TYPE_NAME);
            Object roleTypeInstance = this.roleTypeClass.newInstance();
            roleTypeNameProp.setValue(roleTypeInstance, (Object)name);
            EntityManager em = this.getEntityManager(ctx);
            em.persist(roleTypeInstance);
            em.flush();
            return name;
        }
        catch (Exception ex) {
            throw new IdentityException("Error creating relationship name", (Throwable)ex);
        }
    }

    public EntityManager getEntityManager(IdentityStoreInvocationContext invocationContext) {
        return ((JpaIdentityStoreSessionImpl)invocationContext.getIdentityStoreSession()).getEntityManager();
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        try {
            Object identity = this.getEntityManager(invocationContext).createQuery("select i from " + this.identityClass.getName() + " i where i." + this.modelProperties.get(PROPERTY_IDENTITY_ID).getName() + " = :id").setParameter("id", (Object)id).getSingleResult();
            IdentityObjectTypeImpl type = this.modelProperties.containsKey(PROPERTY_IDENTITY_TYPE_NAME) ? new IdentityObjectTypeImpl(this.modelProperties.get(PROPERTY_IDENTITY_TYPE_NAME).getValue(this.modelProperties.get(PROPERTY_IDENTITY_TYPE).getValue(identity)).toString()) : new IdentityObjectTypeImpl(this.modelProperties.get(PROPERTY_IDENTITY_TYPE).getValue(identity).toString());
            return new IdentityObjectImpl(this.modelProperties.get(PROPERTY_IDENTITY_ID).getValue(identity).toString(), this.modelProperties.get(PROPERTY_IDENTITY_NAME).getValue(identity).toString(), type);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        try {
            String identityType = this.modelProperties.containsKey(PROPERTY_IDENTITY_TYPE_NAME) ? this.lookupIdentityType(identityObjectType.getName(), this.getEntityManager(invocationContext)) : identityObjectType.getName();
            Object identity = this.getEntityManager(invocationContext).createQuery("select i from " + this.identityClass.getName() + " i where i." + this.modelProperties.get(PROPERTY_IDENTITY_NAME).getName() + " = :name and i." + this.modelProperties.get(PROPERTY_IDENTITY_TYPE).getName() + " = :type").setParameter("name", (Object)name).setParameter("type", (Object)identityType).getSingleResult();
            return new IdentityObjectImpl(this.modelProperties.get(PROPERTY_IDENTITY_ID).getValue(identity).toString(), this.modelProperties.get(PROPERTY_IDENTITY_NAME).getValue(identity).toString(), identityObjectType);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        ArrayList<IdentityObject> objs = new ArrayList<IdentityObject>();
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.identityClass);
        Root root = criteria.from(this.identityClass);
        Property<Object> identityTypeProp = this.modelProperties.get(PROPERTY_IDENTITY_TYPE);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (identityType != null) {
            predicates.add(builder.equal((Expression)root.get(identityTypeProp.getName()), this.lookupIdentityType(identityType.getName(), em)));
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        EntityToSpiConverter converter = new EntityToSpiConverter();
        for (Object result : results) {
            objs.add(converter.convertToIdentityObject(result));
        }
        return objs;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria searchCriteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> names = new HashSet<String>();
        if (!this.featuresMetaData.isNamedRelationshipsSupported()) {
            return names;
        }
        Property<Object> roleTypeNameProp = this.modelProperties.get(PROPERTY_ROLE_TYPE_NAME);
        if (this.roleTypeClass != null) {
            EntityManager em = this.getEntityManager(ctx);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.roleTypeClass);
            criteria.from(this.roleTypeClass);
            List results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                names.add(roleTypeNameProp.getValue(result).toString());
            }
        }
        return names;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria searchCriteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> names = new HashSet<String>();
        if (!this.featuresMetaData.isNamedRelationshipsSupported()) {
            return names;
        }
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.relationshipClass);
        Root root = criteria.from(this.relationshipClass);
        Property<Object> identityToProperty = this.modelProperties.get(PROPERTY_RELATIONSHIP_TO);
        Property<Object> relationshipNameProperty = this.modelProperties.get(PROPERTY_RELATIONSHIP_NAME);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(identityToProperty.getName()), this.lookupIdentity(identity, em)));
        Path rolesOnly = root.get(relationshipNameProperty.getName());
        predicates.add(builder.like((Expression)rolesOnly, "%"));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        for (Object result : results) {
            names.add((String)relationshipNameProperty.getValue(result));
        }
        return names;
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("getRelationshipProperties() not supported");
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.featuresMetaData;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        this.removeRelationships(ctx, identity, null, false);
        EntityManager em = this.getEntityManager(ctx);
        Property<Object> nameProperty = this.modelProperties.get(PROPERTY_IDENTITY_NAME);
        Property<Object> typeProperty = this.modelProperties.get(PROPERTY_IDENTITY_TYPE);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.identityClass);
        Root root = criteria.from(this.identityClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(nameProperty.getName()), (Object)identity.getName()));
        predicates.add(builder.equal((Expression)root.get(typeProperty.getName()), this.lookupIdentityType(identity.getIdentityType().getName(), em)));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        try {
            List results;
            Object instance = em.createQuery(criteria).getSingleResult();
            if (this.credentialClass != null) {
                Property<Object> credentialIdentityProp = this.modelProperties.get(PROPERTY_CREDENTIAL_IDENTITY);
                criteria = builder.createQuery(this.credentialClass);
                root = criteria.from(this.credentialClass);
                predicates = new ArrayList();
                predicates.add(builder.equal((Expression)root.get(credentialIdentityProp.getName()), instance));
                criteria.where(predicates.toArray(new Predicate[predicates.size()]));
                results = em.createQuery(criteria).getResultList();
                for (Object result : results) {
                    em.remove(result);
                }
            }
            if (this.attributeClass != null) {
                Property<Object> attributeIdentityProperty = this.modelProperties.get(PROPERTY_ATTRIBUTE_IDENTITY);
                criteria = builder.createQuery(this.attributeClass);
                root = criteria.from(this.attributeClass);
                predicates = new ArrayList();
                predicates.add(builder.equal((Expression)root.get(attributeIdentityProperty.getName()), instance));
                criteria.where(predicates.toArray(new Predicate[predicates.size()]));
                results = em.createQuery(criteria).getResultList();
                for (Object result : results) {
                    em.remove(result);
                }
            }
            em.remove(instance);
        }
        catch (NoResultException ex) {
            throw new IdentityException(String.format("Exception removing identity object - [%s] not found.", identity), (Throwable)ex);
        }
    }

    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        Property<Object> fromProperty = this.modelProperties.get(PROPERTY_RELATIONSHIP_FROM);
        Property<Object> toProperty = this.modelProperties.get(PROPERTY_RELATIONSHIP_TO);
        Property<Object> relationshipTypeProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE);
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.relationshipClass);
        Root root = criteria.from(this.relationshipClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(fromProperty.getName()), this.lookupIdentity(fromIdentity, em)));
        predicates.add(builder.equal((Expression)root.get(toProperty.getName()), this.lookupIdentity(toIdentity, em)));
        predicates.add(builder.equal((Expression)root.get(relationshipTypeProp.getName()), this.lookupRelationshipType(relationshipType, em)));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        Object relationship = em.createQuery(criteria).getSingleResult();
        em.remove(relationship);
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        Property<Object> nameProp = this.modelProperties.get(PROPERTY_ROLE_TYPE_NAME);
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.roleTypeClass);
        Root root = criteria.from(this.roleTypeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(nameProp.getName()), (Object)name));
        criteria.where(predicates.toArray(new Predicate[0]));
        Object roleType = em.createQuery(criteria).getSingleResult();
        em.remove(roleType);
        return null;
    }

    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.relationshipClass);
        Root root = criteria.from(this.relationshipClass);
        Property<Object> relationshipFromProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_FROM);
        Property<Object> relationshipToProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TO);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (identity1 != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipFromProp.getName()), this.lookupIdentity(identity1, em)));
        }
        if (identity2 != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipToProp.getName()), this.lookupIdentity(identity2, em)));
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        for (Object result : results) {
            em.remove(result);
        }
        criteria = builder.createQuery(this.relationshipClass);
        criteria.from(this.relationshipClass);
        predicates = new ArrayList();
        if (identity2 != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipFromProp.getName()), this.lookupIdentity(identity2, em)));
        }
        if (identity1 != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipToProp.getName()), this.lookupIdentity(identity1, em)));
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        results = em.createQuery(criteria).getResultList();
        for (Object result : results) {
            em.remove(result);
        }
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.relationshipClass);
        Root root = criteria.from(this.relationshipClass);
        Property<Object> relationshipFromProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_FROM);
        Property<Object> relationshipToProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TO);
        Property<Object> relationshipTypeProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE);
        Property<Object> relationshipNameProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_NAME);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (fromIdentity != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipFromProp.getName()), this.lookupIdentity(fromIdentity, em)));
        }
        if (toIdentity != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipToProp.getName()), this.lookupIdentity(toIdentity, em)));
        }
        if (relationshipType != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipTypeProp.getName()), this.lookupRelationshipType(relationshipType, em)));
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        EntityToSpiConverter converter = new EntityToSpiConverter();
        for (Object result : results) {
            IdentityObjectRelationshipImpl relationship = new IdentityObjectRelationshipImpl(converter.convertToIdentityObject(relationshipFromProp.getValue(result)), converter.convertToIdentityObject(relationshipToProp.getValue(result)), (String)relationshipNameProp.getValue(result), converter.convertToRelationshipType(relationshipTypeProp.getValue(result)));
            relationships.add(relationship);
        }
        return relationships;
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) throws IdentityException {
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        EntityManager em = this.getEntityManager(ctx);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.relationshipClass);
        Root root = criteria.from(this.relationshipClass);
        Property<Object> relationshipFromProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_FROM);
        Property<Object> relationshipToProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TO);
        Property<Object> relationshipTypeProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_TYPE);
        Property<Object> relationshipNameProp = this.modelProperties.get(PROPERTY_RELATIONSHIP_NAME);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (parent) {
            predicates.add(builder.equal((Expression)root.get(relationshipFromProp.getName()), this.lookupIdentity(identity, em)));
        } else {
            predicates.add(builder.equal((Expression)root.get(relationshipToProp.getName()), this.lookupIdentity(identity, em)));
        }
        if (relationshipType != null) {
            predicates.add(builder.equal((Expression)root.get(relationshipTypeProp.getName()), this.lookupRelationshipType(relationshipType, em)));
        }
        if (named) {
            if (name != null) {
                predicates.add(builder.equal((Expression)root.get(relationshipNameProp.getName()), (Object)name));
            } else {
                predicates.add(builder.isNotNull((Expression)root.get(relationshipNameProp.getName())));
            }
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        EntityToSpiConverter converter = new EntityToSpiConverter();
        for (Object result : results) {
            IdentityObjectRelationshipImpl relationship = new IdentityObjectRelationshipImpl(converter.convertToIdentityObject(relationshipFromProp.getValue(result)), converter.convertToIdentityObject(relationshipToProp.getValue(result)), (String)relationshipNameProp.getValue(result), converter.convertToRelationshipType(relationshipTypeProp.getValue(result)));
            relationships.add(relationship);
        }
        return relationships;
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        EntityManager em = this.getEntityManager(ctx);
        Property<Object> credentialValue = this.modelProperties.get(PROPERTY_CREDENTIAL_VALUE);
        if (this.credentialClass != null) {
            Property<Object> credentialIdentity = this.modelProperties.get(PROPERTY_CREDENTIAL_IDENTITY);
            Property<Object> credentialType = this.modelProperties.get(PROPERTY_CREDENTIAL_TYPE);
            Object identity = this.lookupIdentity(identityObject, em);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.credentialClass);
            Root root = criteria.from(this.credentialClass);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(credentialIdentity.getName()), identity));
            if (credentialType != null) {
                if (String.class.equals((Object)credentialType.getJavaClass())) {
                    predicates.add(builder.equal((Expression)root.get(credentialType.getName()), (Object)credential.getType().getName()));
                } else {
                    predicates.add(builder.equal((Expression)root.get(credentialType.getName()), this.lookupCredentialTypeEntity(credential.getType().getName(), em)));
                }
            }
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            if (results.isEmpty()) {
                try {
                    Object newCredential = this.credentialClass.newInstance();
                    credentialIdentity.setValue(newCredential, identity);
                    credentialValue.setValue(newCredential, credential.getValue());
                    credentialType.setValue(newCredential, this.lookupCredentialTypeEntity(credential.getType().getName(), em));
                    em.persist(newCredential);
                }
                catch (IllegalAccessException ex) {
                    throw new IdentityException("Error updating credential - could not create credential instance", (Throwable)ex);
                }
                catch (InstantiationException ex) {
                    throw new IdentityException("Error updating credential - could not create credential instance", (Throwable)ex);
                }
            } else {
                Object result = results.get(0);
                credentialValue.setValue(result, credential.getValue());
                em.merge(result);
            }
        } else {
            Property<Object> credentialProp = this.modelProperties.get(PROPERTY_CREDENTIAL_VALUE);
            Object identity = this.lookupIdentity(identityObject, em);
            credentialProp.setValue(identity, credential.getValue());
            em.merge(identity);
        }
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        EntityManager em = this.getEntityManager(ctx);
        Property<Object> credentialValue = this.modelProperties.get(PROPERTY_CREDENTIAL_VALUE);
        if (this.credentialClass != null) {
            Property<Object> credentialIdentity = this.modelProperties.get(PROPERTY_CREDENTIAL_IDENTITY);
            Property<Object> credentialType = this.modelProperties.get(PROPERTY_CREDENTIAL_TYPE);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.credentialClass);
            Root root = criteria.from(this.credentialClass);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(credentialIdentity.getName()), this.lookupIdentity(identityObject, em)));
            if (credentialType != null) {
                if (String.class.equals((Object)credentialType.getJavaClass())) {
                    predicates.add(builder.equal((Expression)root.get(credentialType.getName()), (Object)credential.getType().getName()));
                } else {
                    predicates.add(builder.equal((Expression)root.get(credentialType.getName()), this.lookupCredentialTypeEntity(credential.getType().getName(), em)));
                }
            }
            criteria.where(predicates.toArray(new Predicate[0]));
            List results = em.createQuery(criteria).getResultList();
            if (results.isEmpty()) {
                return false;
            }
            for (Object result : results) {
                Object val = credentialValue.getValue(result);
                if (!val.equals(credential.getValue())) continue;
                return true;
            }
        } else {
            Property<Object> identityNameProp = this.modelProperties.get(PROPERTY_IDENTITY_NAME);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(credentialValue.getDeclaringClass());
            Root root = criteria.from(credentialValue.getDeclaringClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(identityNameProp.getName()), (Object)identityObject.getName()));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            Object result = em.createQuery(criteria).getSingleResult();
            Object val = credentialValue.getValue(result);
            if (val.equals(credential.getValue())) {
                return true;
            }
        }
        return false;
    }

    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectAttribute[] attributes) throws IdentityException {
        try {
            EntityManager em = this.getEntityManager(ctx);
            Object identity = this.lookupIdentity(identityObject, em);
            HashSet<IdentityObjectAttribute> filteredAttribs = new HashSet<IdentityObjectAttribute>();
            for (IdentityObjectAttribute attrib : attributes) {
                if (this.attributeProperties.containsKey(attrib.getName())) {
                    MappedAttribute mappedAttribute = this.attributeProperties.get(attrib.getName());
                    if (mappedAttribute.getIdentityProperty() == null) {
                        mappedAttribute.getAttributeProperty().setValue(identity, attrib.getValue());
                        continue;
                    }
                    mappedAttribute.getAttributeProperty().setValue(mappedAttribute.getIdentityProperty().getValue(identity), attrib.getValue());
                    continue;
                }
                filteredAttribs.add(attrib);
            }
            if (!filteredAttribs.isEmpty() && this.attributeClass != null) {
                Property<Object> attributeIdentityProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_IDENTITY);
                Property<Object> attributeNameProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_NAME);
                Property<Object> attributeValueProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_VALUE);
                for (IdentityObjectAttribute attrib : filteredAttribs) {
                    if (attrib.getSize() == 1) {
                        Object attribute = this.attributeClass.newInstance();
                        attributeIdentityProp.setValue(attribute, identity);
                        attributeNameProp.setValue(attribute, (Object)attrib.getName());
                        attributeValueProp.setValue(attribute, attrib.getValue());
                        em.persist(attribute);
                        continue;
                    }
                    for (Object value : attrib.getValues()) {
                        Object attribute = this.attributeClass.newInstance();
                        attributeIdentityProp.setValue(attribute, identity);
                        attributeNameProp.setValue(attribute, (Object)attrib.getName());
                        attributeValueProp.setValue(attribute, value);
                        em.persist(attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IdentityException("Error while adding attributes.", (Throwable)e);
        }
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext ctx, IdentityObject identity, String name) throws IdentityException {
        EntityManager em = this.getEntityManager(ctx);
        if (this.attributeProperties.containsKey(name)) {
            return this.getMappedAttribute(ctx, identity, name);
        }
        if (this.attributeClass == null) {
            return new SimpleAttribute(name);
        }
        Property<Object> attributeIdentityProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_IDENTITY);
        Property<Object> attributeNameProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_NAME);
        Property<Object> attributeValueProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_VALUE);
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.attributeClass);
        Root root = criteria.from(this.attributeClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(attributeIdentityProp.getName()), this.lookupIdentity(identity, em)));
        predicates.add(builder.equal((Expression)root.get(attributeNameProp.getName()), (Object)name));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.size() == 0) {
            return new SimpleAttribute(name);
        }
        if (results.size() == 1) {
            return new SimpleAttribute(name, attributeValueProp.getValue(results.get(0)));
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object result : results) {
            values.add(attributeValueProp.getValue(result));
        }
        return new SimpleAttribute(name, values.toArray());
    }

    private IdentityObjectAttribute getMappedAttribute(IdentityStoreInvocationContext ctx, IdentityObject identity, String name) throws IdentityException {
        MappedAttribute mappedAttribute = this.attributeProperties.get(name);
        EntityManager em = this.getEntityManager(ctx);
        if (mappedAttribute.getIdentityProperty() == null) {
            return new SimpleAttribute(name, mappedAttribute.getAttributeProperty().getValue(this.lookupIdentity(identity, em)));
        }
        return new SimpleAttribute(name, mappedAttribute.getAttributeProperty().getValue(mappedAttribute.getIdentityProperty().getValue(this.lookupIdentity(identity, em))));
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identityObject) throws IdentityException {
        HashMap<String, IdentityObjectAttribute> attributes = new HashMap<String, IdentityObjectAttribute>();
        EntityManager em = this.getEntityManager(ctx);
        Object identity = this.lookupIdentity(identityObject, em);
        for (String name : this.attributeProperties.keySet()) {
            attributes.put(name, this.getMappedAttribute(ctx, identityObject, name));
        }
        if (this.attributeClass != null) {
            Property<Object> attributeIdentityProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_IDENTITY);
            Property<Object> attributeNameProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_NAME);
            Property<Object> attributeValueProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_VALUE);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.attributeClass);
            Root root = criteria.from(this.attributeClass);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(attributeIdentityProp.getName()), identity));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                String name = attributeNameProp.getValue(result).toString();
                Object value = attributeValueProp.getValue(result);
                if (attributes.containsKey(name)) {
                    IdentityObjectAttribute attr = (IdentityObjectAttribute)attributes.get(name);
                    attr.addValue(value);
                    continue;
                }
                attributes.put(name, (IdentityObjectAttribute)new SimpleAttribute(name, value));
            }
        }
        return attributes;
    }

    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identityObject, String[] attributeNames) throws IdentityException {
        EntityManager em = this.getEntityManager(ctx);
        Object identity = this.lookupIdentity(identityObject, em);
        if (this.attributeClass != null) {
            Property<Object> attributeIdentityProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_IDENTITY);
            Property<Object> attributeNameProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_NAME);
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.attributeClass);
            Root root = criteria.from(this.attributeClass);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(attributeIdentityProp.getName()), identity));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            block0: for (Object result : results) {
                String name = attributeNameProp.getValue(result).toString();
                for (String n : attributeNames) {
                    if (name == null || !name.equals(n)) continue;
                    em.remove(result);
                    continue block0;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectAttribute[] attributes) throws IdentityException {
        try {
            EntityManager em = this.getEntityManager(ctx);
            Object identity = this.lookupIdentity(identityObject, em);
            HashSet<IdentityObjectAttribute> filteredAttribs = new HashSet<IdentityObjectAttribute>();
            for (IdentityObjectAttribute attrib : attributes) {
                if (this.attributeProperties.containsKey(attrib.getName())) {
                    MappedAttribute mappedAttribute = this.attributeProperties.get(attrib.getName());
                    if (mappedAttribute.getIdentityProperty() == null) {
                        mappedAttribute.getAttributeProperty().setValue(identity, attrib.getValue());
                        continue;
                    }
                    mappedAttribute.getAttributeProperty().setValue(mappedAttribute.getIdentityProperty().getValue(identity), attrib.getValue());
                    continue;
                }
                filteredAttribs.add(attrib);
            }
            if (this.attributeClass == null) return;
            Property<Object> attributeIdentityProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_IDENTITY);
            Property<Object> attributeNameProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_NAME);
            Property<Object> attributeValueProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_VALUE);
            Property<Object> attributeTypeProp = this.modelProperties.get(PROPERTY_ATTRIBUTE_TYPE);
            for (IdentityObjectAttribute attrib : filteredAttribs) {
                CriteriaBuilder builder = em.getCriteriaBuilder();
                CriteriaQuery criteria = builder.createQuery(this.attributeClass);
                Root root = criteria.from(this.attributeClass);
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get(attributeIdentityProp.getName()), identity));
                predicates.add(builder.equal((Expression)root.get(attributeNameProp.getName()), (Object)attrib.getName()));
                criteria.where(predicates.toArray(new Predicate[predicates.size()]));
                List results = em.createQuery(criteria).getResultList();
                if (!results.isEmpty()) {
                    for (Object result : results) {
                        em.remove(result);
                    }
                }
                for (Object value : attrib.getValues()) {
                    Object attribute = this.attributeClass.newInstance();
                    attributeIdentityProp.setValue(attribute, identity);
                    attributeNameProp.setValue(attribute, (Object)attrib.getName());
                    if (attributeTypeProp != null) {
                        if (String.class.equals(value.getClass())) {
                            attributeValueProp.setValue(attribute, (Object)value.toString());
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_TEXT);
                        } else if (Boolean.class.equals(value.getClass()) || Boolean.TYPE.equals(value.getClass())) {
                            attributeValueProp.setValue(attribute, (Object)Boolean.toString((Boolean)value));
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_BOOLEAN);
                        } else if (Date.class.isAssignableFrom(value.getClass())) {
                            attributeValueProp.setValue(attribute, (Object)("" + ((Date)value).getTime()));
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_DATE);
                        } else if (Integer.class.equals(value.getClass()) || Integer.TYPE.equals(value.getClass())) {
                            attributeValueProp.setValue(attribute, (Object)((Integer)value).toString());
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_INT);
                        } else if (Long.class.equals(value.getClass()) || Long.TYPE.equals(value.getClass())) {
                            attributeValueProp.setValue(attribute, (Object)((Long)value).toString());
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_LONG);
                        } else if (Float.class.equals(value.getClass()) || Float.TYPE.equals(value.getClass())) {
                            attributeValueProp.setValue(attribute, (Object)((Float)value).toString());
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_FLOAT);
                        } else {
                            if (!Double.class.equals(value.getClass()) && !Double.TYPE.equals(value.getClass())) throw new IdentityException("Could not persist attribute value - unsupported attribute value type " + value.getClass());
                            attributeValueProp.setValue(attribute, (Object)((Double)value).toString());
                            attributeTypeProp.setValue(attribute, (Object)ATTRIBUTE_TYPE_DOUBLE);
                        }
                    } else {
                        attributeValueProp.setValue(attribute, (Object)value.toString());
                    }
                    em.persist(attribute);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new IdentityException("Error while updating attributes.", (Throwable)e);
        }
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        return this.createIdentityStoreSession(null);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        ArrayList<IdentityObject> objs = new ArrayList<IdentityObject>();
        EntityManager em = this.getEntityManager(invocationCxt);
        Query q = null;
        boolean orderByName = false;
        boolean ascending = true;
        if (criteria != null && criteria.isSorted()) {
            orderByName = true;
            ascending = criteria.isAscending();
        }
        StringBuilder queryString = new StringBuilder();
        IdentityObjectType identityType = identity.getIdentityType();
        String identType = this.modelProperties.containsKey(PROPERTY_IDENTITY_TYPE_NAME) ? this.lookupIdentityType(identityType.getName(), this.getEntityManager(invocationCxt)) : identityType.getName();
        Object ident = this.getEntityManager(invocationCxt).createQuery("select i from " + this.identityClass.getName() + " i where i." + this.modelProperties.get(PROPERTY_IDENTITY_NAME).getName() + " = :name and i." + this.modelProperties.get(PROPERTY_IDENTITY_TYPE).getName() + " = :type").setParameter("name", (Object)identity.getName()).setParameter("type", (Object)identType).getSingleResult();
        if (parent) {
            if (relationshipType != null) {
                queryString.append("select distinct ior.to from IdentityObjectRelationship ior where ior.to.name like :nameFilter and ior.relationshipType.name = :relType and ior.from = :identity");
            } else {
                queryString.append("select distinct ior.to from IdentityObjectRelationship ior where ior.to.name like :nameFilter and ior.from = :identity");
            }
            if (orderByName) {
                queryString.append(" order by ior.to.name" + (ascending ? " asc" : ""));
            }
        } else {
            if (relationshipType != null) {
                queryString.append("select distinct ior.from from IdentityObjectRelationship ior where ior.from.name like :nameFilter and ior.relationshipType.name = :relType and ior.to = :identity");
            } else {
                queryString.append("select distinct ior.from from IdentityObjectRelationship ior where ior.from.name like :nameFilter and ior.to = :identity");
            }
            if (orderByName) {
                queryString.append(" order by ior.to.name" + (ascending ? " asc" : ""));
            }
        }
        q = em.createQuery(queryString.toString()).setParameter("identity", ident);
        if (relationshipType != null) {
            q.setParameter("relType", (Object)relationshipType.getName());
        }
        if (criteria != null && criteria.getFilter() != null) {
            q.setParameter("nameFilter", (Object)criteria.getFilter().replaceAll("\\*", "%"));
        } else {
            q.setParameter("nameFilter", (Object)"%");
        }
        if (criteria != null && criteria.isPaged() && !criteria.isFiltered()) {
            q.setFirstResult(criteria.getFirstResult());
            if (criteria.getMaxResults() > 0) {
                q.setMaxResults(criteria.getMaxResults());
            }
        }
        List results = q.getResultList();
        EntityToSpiConverter converter = new EntityToSpiConverter();
        for (Object result : results) {
            objs.add(converter.convertToIdentityObject(result));
        }
        return objs;
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        return null;
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return null;
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        return null;
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        System.out.println("*** Invoked unimplemented method getIdentityObjectsCount()");
        return 0;
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("getRelationshipNameProperties() not supported");
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("setRelationshipNameProperties() not supported");
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("setRelationshipProperties() not supported");
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("removeRelationshipNameProperties() not supported");
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("removeRelationshipProperties() not supported");
    }

    static /* synthetic */ Map access$000(JpaIdentityStore x0) {
        return x0.modelProperties;
    }

    protected class AttributeValue {
        private String encoded;
        private String type;

        public AttributeValue(String encoded, String type) {
            this.encoded = encoded;
            this.type = type;
        }

        public String getEncoded() {
            return this.encoded;
        }

        public String getType() {
            return this.type;
        }
    }

    private class PropertyTypeCriteria
    implements PropertyCriteria {
        private PropertyType pt;

        public PropertyTypeCriteria(PropertyType pt) {
            this.pt = pt;
        }

        public boolean fieldMatches(Field f) {
            return f.isAnnotationPresent(IdentityProperty.class) && f.getAnnotation(IdentityProperty.class).value().equals((Object)this.pt);
        }

        public boolean methodMatches(Method m) {
            return m.isAnnotationPresent(IdentityProperty.class) && m.getAnnotation(IdentityProperty.class).value().equals((Object)this.pt);
        }
    }

    private class MappedAttribute {
        private Property<Object> identityProperty;
        private Property<Object> attributeProperty;

        public MappedAttribute(Property<Object> identityProperty, Property<Object> attributeProperty) {
            this.identityProperty = identityProperty;
            this.attributeProperty = attributeProperty;
        }

        public Property<Object> getIdentityProperty() {
            return this.identityProperty;
        }

        public Property<Object> getAttributeProperty() {
            return this.attributeProperty;
        }
    }

    private class EntityToSpiConverter {
        private static final String IDENTITY_TYPE_CACHE_PREFIX = "identity_type:";
        private static final String RELATIONSHIP_TYPE_CACHE_PREFIX = "relationship_type:";
        private Map<Object, Object> cache = new HashMap<Object, Object>();
        private Property<?> identityIdProperty = (Property)JpaIdentityStore.access$000(JpaIdentityStore.this).get("IDENTITY_ID");
        private Property<?> identityNameProperty = (Property)JpaIdentityStore.access$000(JpaIdentityStore.this).get("IDENTITY_NAME");
        private Property<?> identityTypeProperty = (Property)JpaIdentityStore.access$000(JpaIdentityStore.this).get("IDENTITY_TYPE");
        private Property<?> identityTypeNameProperty = (Property)JpaIdentityStore.access$000(JpaIdentityStore.this).get("IDENTITY_TYPE_NAME");
        private Property<?> relationshipTypeNameProperty = (Property)JpaIdentityStore.access$000(JpaIdentityStore.this).get("RELATIONSHIP_TYPE_NAME");

        private EntityToSpiConverter() {
        }

        public IdentityObject convertToIdentityObject(Object entity) {
            if (!JpaIdentityStore.this.identityClass.isAssignableFrom(entity.getClass())) {
                throw new IllegalArgumentException("Invalid identity entity");
            }
            if (this.cache.containsKey(entity)) {
                return (IdentityObject)this.cache.get(entity);
            }
            IdentityObjectImpl obj = new IdentityObjectImpl(this.identityIdProperty.getValue(entity).toString(), this.identityNameProperty.getValue(entity).toString(), this.convertToIdentityObjectType(this.identityTypeProperty.getValue(entity)));
            this.cache.put(entity, obj);
            return obj;
        }

        public IdentityObjectType convertToIdentityObjectType(Object value) {
            if (value instanceof String) {
                String key = IDENTITY_TYPE_CACHE_PREFIX + (String)value;
                if (this.cache.containsKey(key)) {
                    return (IdentityObjectType)this.cache.get(key);
                }
                IdentityObjectTypeImpl type = new IdentityObjectTypeImpl((String)value);
                this.cache.put(key, type);
                return type;
            }
            if (this.cache.containsKey(value)) {
                return (IdentityObjectType)this.cache.get(value);
            }
            IdentityObjectTypeImpl type = new IdentityObjectTypeImpl((String)this.identityTypeNameProperty.getValue(value));
            this.cache.put(value, type);
            return type;
        }

        public IdentityObjectRelationshipType convertToRelationshipType(Object value) {
            if (value instanceof String) {
                String key = RELATIONSHIP_TYPE_CACHE_PREFIX + (String)value;
                if (this.cache.containsKey(key)) {
                    return (IdentityObjectRelationshipType)this.cache.get(key);
                }
                IdentityObjectRelationshipTypeImpl type = new IdentityObjectRelationshipTypeImpl((String)value);
                this.cache.put(key, type);
                return type;
            }
            if (this.cache.containsKey(value)) {
                return (IdentityObjectRelationshipType)this.cache.get(value);
            }
            IdentityObjectRelationshipTypeImpl type = new IdentityObjectRelationshipTypeImpl((String)this.relationshipTypeNameProperty.getValue(value));
            this.cache.put(value, type);
            return type;
        }
    }
}

