/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import javax.servlet.ServletContext;

public class WebApplication {
    private final String name;
    private final String contextPath;
    private final String serverInfo;
    private final long startTime;

    public WebApplication(ServletContext ctx) {
        this(ctx.getServletContextName(), ctx.getContextPath(), ctx.getServerInfo());
    }

    public WebApplication(String name, String contextPath, String serverInfo) {
        this.name = name;
        this.contextPath = contextPath;
        this.serverInfo = serverInfo;
        this.startTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getRunningTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextPath == null ? 0 : this.contextPath.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serverInfo == null ? 0 : this.serverInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WebApplication)) {
            return false;
        }
        WebApplication other = (WebApplication)obj;
        if (this.contextPath == null ? other.contextPath != null : !this.contextPath.equals(other.contextPath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.serverInfo == null ? other.serverInfo != null : !this.serverInfo.equals(other.serverInfo));
    }
}

