/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.filter;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.seam.exception.control.ExceptionToCatch;
import org.jboss.seam.servlet.literal.WebRequestLiteral;
import org.jboss.weld.extensions.beanManager.BeanManagerAware;
import org.jboss.weld.extensions.core.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(value={"org.jboss.seam.exception.control.extension.CatchExtension"})
public class CatchExceptionFilter
extends BeanManagerAware
implements Filter {
    private transient Logger log = LoggerFactory.getLogger(CatchExceptionFilter.class);
    @Inject
    private BeanManager beanManager;
    private boolean enabled;

    public void init(FilterConfig config) throws ServletException {
        if (this.beanManager == null) {
            try {
                this.beanManager = this.getBeanManager();
            }
            catch (IllegalStateException e) {
                this.log.info("Could not locate BeanManager. Catch integration for Servlet disabled (even if present on the classpath)");
                return;
            }
        }
        if (!this.beanManager.getBeans(CatchExceptionFilter.class, new Annotation[0]).isEmpty()) {
            this.enabled = true;
            this.log.info("Catch integration for Servlet enabled");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block5: {
            if (!this.enabled) {
                chain.doFilter(request, response);
            } else {
                try {
                    chain.doFilter(request, response);
                }
                catch (Exception e) {
                    ExceptionToCatch catchEvent = new ExceptionToCatch((Throwable)e, new Annotation[]{WebRequestLiteral.INSTANCE});
                    this.beanManager.fireEvent((Object)catchEvent, new Annotation[0]);
                    if (catchEvent.isHandled()) break block5;
                    if (e instanceof ServletException) {
                        throw (ServletException)e;
                    }
                    if (!(e instanceof IOException)) break block5;
                    throw (IOException)e;
                }
            }
        }
    }

    public void destroy() {
    }
}

