/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Enumeration;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.servlet.ServletExtension;
import org.jboss.seam.servlet.http.DefaultValue;
import org.jboss.seam.servlet.http.HeaderParam;
import org.jboss.seam.servlet.http.TypedParamValue;
import org.jboss.seam.servlet.util.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParamProducer {
    @Inject
    private HttpServletRequest request;

    @Produces
    @TypedParamValue
    protected Object getTypedParamValue(InjectionPoint ip, ServletExtension ext) {
        String v = this.getHeaderValue(this.getHeaderName(ip), ip);
        Class<?> t = Primitives.wrap(this.resolveExpectedType(ip));
        if (t.equals(String.class)) {
            return v;
        }
        try {
            Member converter = ext.getConverterMember(t);
            return converter instanceof Constructor ? ((Constructor)converter).newInstance(v) : ((Method)converter).invoke(null, v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getHeaderName(InjectionPoint ip) {
        String headerName = ((HeaderParam)ip.getAnnotated().getAnnotation(HeaderParam.class)).value();
        if ("".equals(headerName)) {
            headerName = ip.getMember().getName();
        }
        return headerName;
    }

    private String getHeaderValue(String headerName, InjectionPoint ip) {
        return this.isHeaderInRequest(headerName) ? this.request.getHeader(headerName) : this.getDefaultValue(ip);
    }

    private boolean isHeaderInRequest(String headerName) {
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            if (!((String)names.nextElement()).equals(headerName)) continue;
            return true;
        }
        return false;
    }

    private String getDefaultValue(InjectionPoint ip) {
        DefaultValue defaultValueAnnotation = (DefaultValue)ip.getAnnotated().getAnnotation(DefaultValue.class);
        return defaultValueAnnotation == null ? null : defaultValueAnnotation.value();
    }

    private Class<?> resolveExpectedType(InjectionPoint ip) {
        Type t = ip.getType();
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getActualTypeArguments().length == 1) {
            return (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        return Object.class;
    }
}

