/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet.event;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.seam.servlet.WebApplication;
import org.jboss.seam.servlet.event.AbstractServletEventBridge;
import org.jboss.seam.servlet.event.ImplicitServletObjectsHolder;
import org.jboss.seam.servlet.event.literal.DestroyedLiteral;
import org.jboss.seam.servlet.event.literal.DidActivateLiteral;
import org.jboss.seam.servlet.event.literal.HttpMethodLiteral;
import org.jboss.seam.servlet.event.literal.InitializedLiteral;
import org.jboss.seam.servlet.event.literal.PathLiteral;
import org.jboss.seam.servlet.event.literal.WillPassivateLiteral;

public class ServletEventBridgeListener
extends AbstractServletEventBridge
implements HttpSessionActivationListener,
HttpSessionListener,
ServletContextListener,
ServletRequestListener {
    public void contextInitialized(ServletContextEvent e) {
        this.fireEvent(new ImplicitServletObjectsHolder.InternalServletContextEvent(e.getServletContext()), InitializedLiteral.INSTANCE);
        WebApplication webapp = new WebApplication(e.getServletContext());
        e.getServletContext().setAttribute(WEB_APPLICATION_ATTRIBUTE_NAME, (Object)webapp);
        this.fireEvent(webapp, InitializedLiteral.INSTANCE);
        this.fireEvent(e.getServletContext(), InitializedLiteral.INSTANCE);
    }

    public void contextDestroyed(ServletContextEvent e) {
        this.fireEvent(new ImplicitServletObjectsHolder.InternalServletContextEvent(e.getServletContext()), DestroyedLiteral.INSTANCE);
    }

    public void requestInitialized(ServletRequestEvent e) {
        this.fireEvent(new ImplicitServletObjectsHolder.InternalServletRequestEvent(e.getServletRequest()), InitializedLiteral.INSTANCE);
        if (e.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)HttpServletRequest.class.cast(e.getServletRequest());
            this.fireEvent(e.getServletRequest(), InitializedLiteral.INSTANCE, new PathLiteral(httpRequest.getServletPath()), new HttpMethodLiteral(httpRequest.getMethod()));
        } else {
            this.fireEvent(e.getServletRequest(), InitializedLiteral.INSTANCE);
        }
    }

    public void requestDestroyed(ServletRequestEvent e) {
        if (e.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)HttpServletRequest.class.cast(e.getServletRequest());
            this.fireEvent(e.getServletRequest(), DestroyedLiteral.INSTANCE, new PathLiteral(httpRequest.getServletPath()), new HttpMethodLiteral(httpRequest.getMethod()));
        } else {
            this.fireEvent(e.getServletRequest(), DestroyedLiteral.INSTANCE);
        }
        this.fireEvent(new ImplicitServletObjectsHolder.InternalServletRequestEvent(e.getServletRequest()), DestroyedLiteral.INSTANCE);
    }

    public void sessionCreated(HttpSessionEvent e) {
        this.fireEvent(new ImplicitServletObjectsHolder.InternalHttpSessionEvent(e.getSession()), InitializedLiteral.INSTANCE);
        this.fireEvent(e.getSession(), InitializedLiteral.INSTANCE);
    }

    public void sessionDestroyed(HttpSessionEvent e) {
        this.fireEvent(e.getSession(), DestroyedLiteral.INSTANCE);
        this.fireEvent(new ImplicitServletObjectsHolder.InternalHttpSessionEvent(e.getSession()), DestroyedLiteral.INSTANCE);
    }

    public void sessionDidActivate(HttpSessionEvent e) {
        this.fireEvent(e.getSession(), DidActivateLiteral.INSTANCE);
    }

    public void sessionWillPassivate(HttpSessionEvent e) {
        this.fireEvent(e.getSession(), WillPassivateLiteral.INSTANCE);
    }
}

