/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.examples.webclient;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.social.MultiServicesManager;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthToken;
import org.jboss.solder.logging.Logger;

@Named
@SessionScoped
public class SocialClient
implements Serializable {
    private static final long serialVersionUID = 3723552335163650582L;
    @Inject
    private MultiServicesManager manager;
    @Inject
    private Logger log;

    public MultiServicesManager getManager() {
        return this.manager;
    }

    public void setManager(MultiServicesManager manager) {
        this.manager = manager;
    }

    @Produces
    @Named
    public OAuthService getCurrentService() {
        return this.manager.getCurrentService();
    }

    public void setCurrentService(OAuthService currentService) {
        this.manager.setCurrentService(currentService);
    }

    public Map<String, OAuthService> getServicesMap() {
        return Maps.uniqueIndex((Iterable)this.getServices(), (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<OAuthService> getServices() {
        return new ArrayList<OAuthService>(this.manager.getServices());
    }

    public OAuthToken getAccessToken() {
        return this.getCurrentService().getAccessToken();
    }

    public void connectCurrentService() {
        this.manager.connectCurrentService();
    }

    public String getCurrentServiceName() {
        return this.getCurrentService() == null ? "" : this.getCurrentService().getName();
    }

    public void setCurrentServiceName(String cursrvHdlStr) {
        this.setCurrentService((OAuthService)this.getServicesMap().get(cursrvHdlStr));
    }

    public void redirectToAuthorizationURL(String url) throws IOException {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        externalContext.redirect(url);
    }

    public String getTimeLineUrl() {
        if (this.getCurrentService().isConnected()) {
            return "/WEB-INF/fragments/" + this.getCurrentService().getType().toLowerCase() + ".xhtml";
        }
        return "";
    }

    public void serviceInit(String servType) throws IOException {
        this.redirectToAuthorizationURL(this.manager.initNewService(servType));
    }

    public void resetConnection() {
        this.manager.destroyCurrentService();
    }
}

