/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.bean.generic;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.bean.ImmutableInjectionPoint;
import org.jboss.seam.solder.bean.generic.AbstractGenericProducerBean;
import org.jboss.seam.solder.bean.generic.GenericConfiguration;
import org.jboss.seam.solder.bean.generic.GenericIdentifier;
import org.jboss.seam.solder.bean.generic.GenericMarker;
import org.jboss.seam.solder.bean.generic.InjectGeneric;
import org.jboss.seam.solder.reflection.Synthetic;
import org.jboss.seam.solder.reflection.annotated.Annotateds;
import org.jboss.seam.solder.reflection.annotated.InjectableMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericProducerMethod<T, X>
extends AbstractGenericProducerBean<T> {
    private final InjectableMethod<X> producerMethod;
    private final InjectableMethod<X> disposerMethod;

    GenericProducerMethod(Bean<T> originalBean, GenericIdentifier identifier, AnnotatedMethod<X> method, AnnotatedMethod<X> disposerMethod, Set<Annotation> qualifiers, Set<Annotation> genericBeanQualifiers, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> declaringBeanClass, BeanManager beanManager) {
        super(originalBean, identifier, qualifiers, genericBeanQualifiers, scopeOverride, Annotateds.createCallableId(method), alternative, declaringBeanClass, beanManager);
        List injectionPoints = Beans.createInjectionPoints(method, (Bean)this, (BeanManager)beanManager);
        ArrayList<InjectionPoint> wrappedInjectionPoints = new ArrayList<InjectionPoint>();
        for (InjectionPoint injectionPoint : injectionPoints) {
            wrappedInjectionPoints.add(GenericProducerMethod.wrapInjectionPoint(injectionPoint, genericBeanQualifiers));
        }
        this.producerMethod = new InjectableMethod(method, wrappedInjectionPoints, beanManager);
        if (disposerMethod != null) {
            injectionPoints = Beans.createInjectionPoints(disposerMethod, (Bean)this, (BeanManager)beanManager);
            wrappedInjectionPoints = new ArrayList();
            for (InjectionPoint injectionPoint : injectionPoints) {
                wrappedInjectionPoints.add(GenericProducerMethod.wrapInjectionPoint(injectionPoint, genericBeanQualifiers));
            }
            this.disposerMethod = new InjectableMethod(disposerMethod, wrappedInjectionPoints, beanManager);
        } else {
            this.disposerMethod = null;
        }
    }

    @Override
    protected T getValue(Object receiver, CreationalContext<T> creationalContext) {
        return (T)this.producerMethod.invoke(receiver, creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (this.disposerMethod != null) {
            this.disposerMethod.invoke(this.getReceiver(creationalContext), creationalContext);
        }
    }

    private static InjectionPoint wrapInjectionPoint(InjectionPoint injectionPoint, Set<Annotation> quals) {
        Annotated anotated = injectionPoint.getAnnotated();
        boolean genericInjectionPoint = false;
        if (injectionPoint.getType() instanceof Class) {
            Class c = (Class)injectionPoint.getType();
            genericInjectionPoint = c.isAnnotationPresent(GenericConfiguration.class);
        }
        if (anotated.isAnnotationPresent(Disposes.class) || anotated.isAnnotationPresent(InjectGeneric.class) || genericInjectionPoint) {
            HashSet<Annotation> newQualifiers = new HashSet<Annotation>();
            newQualifiers.addAll(quals);
            newQualifiers.addAll(injectionPoint.getQualifiers());
            Iterator it = newQualifiers.iterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                if (annotation.annotationType().equals(Synthetic.class)) {
                    it.remove();
                    continue;
                }
                if (!annotation.annotationType().equals(GenericMarker.class)) continue;
                it.remove();
            }
            return new ImmutableInjectionPoint((AnnotatedParameter)anotated, newQualifiers, injectionPoint.getBean(), injectionPoint.isTransient(), injectionPoint.isDelegate());
        }
        return injectionPoint;
    }
}

