/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.log;

import java.lang.reflect.Type;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.seam.solder.log.Category;
import org.jboss.seam.solder.log.Locale;
import org.jboss.seam.solder.log.Suffix;
import org.jboss.seam.solder.log.TypedCategory;
import org.jboss.seam.solder.log.TypedLogger;
import org.jboss.seam.solder.log.TypedMessageBundle;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.util.Locales;

class LoggerProducers {
    LoggerProducers() {
    }

    @Produces
    Logger produceLog(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Category.class)) {
            if (annotated.isAnnotationPresent(Suffix.class)) {
                return Logger.getLogger((String)((Category)annotated.getAnnotation(Category.class)).value(), (String)((Suffix)annotated.getAnnotation(Suffix.class)).value());
            }
            return Logger.getLogger((String)((Category)annotated.getAnnotation(Category.class)).value());
        }
        if (annotated.isAnnotationPresent(TypedCategory.class)) {
            if (annotated.isAnnotationPresent(Suffix.class)) {
                return Logger.getLogger((Class)((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value(), (String)((Suffix)annotated.getAnnotation(Suffix.class)).value());
            }
            return Logger.getLogger((Class)((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value());
        }
        if (annotated.isAnnotationPresent(Suffix.class)) {
            return Logger.getLogger((Class)Reflections.getRawType((Type)injectionPoint.getBean().getBeanClass()), (String)((Suffix)annotated.getAnnotation(Suffix.class)).value());
        }
        return Logger.getLogger((Class)Reflections.getRawType((Type)injectionPoint.getBean().getBeanClass()));
    }

    @Produces
    @TypedLogger
    Object produceTypedLogger(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Category.class) || !annotated.isAnnotationPresent(TypedCategory.class)) {
            // empty if block
        }
        if (annotated.isAnnotationPresent(Category.class)) {
            if (annotated.isAnnotationPresent(Locale.class)) {
                return Logger.getMessageLogger((Class)Reflections.getRawType((Type)injectionPoint.getType()), (String)((Category)annotated.getAnnotation(Category.class)).value(), (java.util.Locale)Locales.toLocale((String)((Locale)annotated.getAnnotation(Locale.class)).value()));
            }
            return Logger.getMessageLogger((Class)Reflections.getRawType((Type)injectionPoint.getType()), (String)((Category)annotated.getAnnotation(Category.class)).value());
        }
        if (annotated.isAnnotationPresent(TypedCategory.class)) {
            if (annotated.isAnnotationPresent(Locale.class)) {
                return Logger.getMessageLogger((Class)Reflections.getRawType((Type)injectionPoint.getType()), (String)((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value().getName(), (java.util.Locale)Locales.toLocale((String)((Locale)annotated.getAnnotation(Locale.class)).value()));
            }
            return Logger.getMessageLogger((Class)Reflections.getRawType((Type)injectionPoint.getType()), (String)((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value().getName());
        }
        throw new IllegalStateException("Must specify @Category or @TypedCategory for typed loggers at [" + injectionPoint + "]");
    }

    @Produces
    @TypedMessageBundle
    Object produceTypedMessageBundle(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Locale.class)) {
            return Messages.getBundle((Class)Reflections.getRawType((Type)injectionPoint.getType()), (java.util.Locale)Locales.toLocale((String)((Locale)annotated.getAnnotation(Locale.class)).value()));
        }
        return Messages.getBundle((Class)Reflections.getRawType((Type)injectionPoint.getType()));
    }
}

