/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.servicehandler;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.logging.Logger;
import org.jboss.seam.solder.bean.BeanBuilder;
import org.jboss.seam.solder.reflection.AnnotationInspector;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.servicehandler.ServiceHandler;
import org.jboss.seam.solder.servicehandler.ServiceHandlerBeanLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceHandlerExtension
implements Extension {
    private final Set<Bean<?>> beans = new HashSet();
    private static final Logger log = Logger.getLogger(ServiceHandlerExtension.class);
    private final boolean enabled;
    private final Set<Throwable> problems = new HashSet<Throwable>();

    public ServiceHandlerExtension() {
        boolean en = true;
        try {
            Reflections.classForName((String)"javassist.util.proxy.MethodHandler", (ClassLoader[])new ClassLoader[]{ServiceHandlerExtension.class.getClassLoader()});
        }
        catch (ClassNotFoundException e) {
            en = false;
            log.debug((Object)"Javassist not preset, @ServiceHandler is disabled");
        }
        this.enabled = en;
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        ServiceHandler annotation = (ServiceHandler)AnnotationInspector.getMetaAnnotation((Annotated)event.getAnnotatedType(), ServiceHandler.class);
        if (annotation != null) {
            if (!this.enabled) {
                this.problems.add(new RuntimeException("Javassist not found on the class path, @ServiceHandler requires javassist to work. @ServiceHandler found on " + event.getAnnotatedType()));
            } else {
                Class handlerClass = annotation.value();
                try {
                    BeanBuilder builder = new BeanBuilder(beanManager);
                    builder.readFromType(event.getAnnotatedType());
                    builder.beanLifecycle(new ServiceHandlerBeanLifecycle(event.getAnnotatedType().getJavaClass(), handlerClass, beanManager));
                    builder.toString("Generated @ServiceHandler for [" + builder.getBeanClass() + "] with qualifiers [" + builder.getQualifiers() + "] handled by " + handlerClass);
                    this.beans.add(builder.create());
                    log.debug((Object)("Adding @ServiceHandler bean for [" + builder.getBeanClass() + "] with qualifiers [" + builder.getQualifiers() + "] handled by " + handlerClass));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        for (Bean<?> bean : this.beans) {
            event.addBean(bean);
        }
        for (Throwable e : this.problems) {
            event.addDefinitionError(e);
        }
        this.beans.clear();
    }
}

