/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.bean.generic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.seam.solder.bean.ImmutableInjectionPoint;
import org.jboss.seam.solder.bean.generic.AbstactGenericBean;
import org.jboss.seam.solder.bean.generic.GenericIdentifier;
import org.jboss.seam.solder.bean.generic.InjectGeneric;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.reflection.Synthetic;
import org.jboss.seam.solder.reflection.annotated.Annotateds;

class GenericManagedBean<T>
extends AbstactGenericBean<T> {
    private final InjectionTarget<T> injectionTarget;
    private final Map<AnnotatedField<? super T>, InjectionPoint> injectedFields;
    private final Class<? extends Annotation> scopeOverride;

    GenericManagedBean(Bean<T> originalBean, GenericIdentifier identifier, InjectionTarget<T> injectionTarget, AnnotatedType<T> type, Set<Annotation> qualifiers, Class<? extends Annotation> scopeOverride, Synthetic.Provider annotatedMemberSyntheticProvider, boolean alternative, Class<?> beanClass, BeanManager beanManager) {
        super(originalBean, qualifiers, identifier, Annotateds.createTypeId(type), alternative, beanClass, beanManager);
        this.injectionTarget = injectionTarget;
        this.injectedFields = new HashMap<AnnotatedField<? super T>, InjectionPoint>();
        this.scopeOverride = scopeOverride;
        HashSet<Annotation> filteredQualifiers = new HashSet<Annotation>(this.getQualifiers());
        filteredQualifiers.remove(AnyLiteral.INSTANCE);
        for (AnnotatedField field : type.getFields()) {
            if (!field.isAnnotationPresent(InjectGeneric.class)) continue;
            if (AnnotatedMember.class.isAssignableFrom(field.getJavaMember().getType())) {
                this.injectedFields.put(field, new ImmutableInjectionPoint(field, Collections.singleton(annotatedMemberSyntheticProvider.get(identifier)), this, false, false));
            } else {
                this.injectedFields.put(field, new ImmutableInjectionPoint(field, filteredQualifiers, this, false, false));
            }
            if (field.getJavaMember().isAccessible()) continue;
            field.getJavaMember().setAccessible(true);
        }
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        Object instance = this.injectionTarget.produce(creationalContext);
        this.injectionTarget.inject(instance, creationalContext);
        for (Map.Entry<AnnotatedField<T>, InjectionPoint> field : this.injectedFields.entrySet()) {
            Object value = this.getBeanManager().getInjectableReference(field.getValue(), creationalContext);
            field.getKey().getJavaMember().setAccessible(true);
            Reflections.setFieldValue((Field)field.getKey().getJavaMember(), (Object)instance, (Object)value);
        }
        this.injectionTarget.postConstruct(instance);
        return (T)instance;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        if (this.scopeOverride != null) {
            return this.scopeOverride;
        }
        return super.getScope();
    }
}

