/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.jboss.logging.JBossLogManagerLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.MDC;
import org.jboss.logmanager.NDC;

final class JBossLogManagerProvider
implements LoggerProvider {
    private static final Logger.AttachmentKey<Logger> KEY = new Logger.AttachmentKey();

    JBossLogManagerProvider() {
    }

    public Logger getLogger(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Logger>(){

                @Override
                public Logger run() {
                    return JBossLogManagerProvider.doGetLogger(name);
                }
            });
        }
        return JBossLogManagerProvider.doGetLogger(name);
    }

    private static Logger doGetLogger(String name) {
        Logger l = (Logger)LogContext.getLogContext().getAttachment(name, KEY);
        if (l != null) {
            return l;
        }
        org.jboss.logmanager.Logger logger = org.jboss.logmanager.Logger.getLogger((String)name);
        Logger a = (Logger)logger.attachIfAbsent(KEY, (Object)(l = new JBossLogManagerLogger(name, logger)));
        if (a == null) {
            return l;
        }
        return a;
    }

    public Object putMdc(String key, Object value) {
        return MDC.put((String)key, (String)String.valueOf(value));
    }

    public Object getMdc(String key) {
        return MDC.get((String)key);
    }

    public void removeMdc(String key) {
        MDC.remove((String)key);
    }

    public Map<String, Object> getMdcMap() {
        return MDC.copy();
    }

    public void clearNdc() {
        NDC.clear();
    }

    public String getNdc() {
        return NDC.get();
    }

    public int getNdcDepth() {
        return NDC.getDepth();
    }

    public String popNdc() {
        return NDC.pop();
    }

    public String peekNdc() {
        return NDC.get();
    }

    public void pushNdc(String message) {
        NDC.push((String)message);
    }

    public void setNdcMaxDepth(int maxDepth) {
        NDC.trimTo((int)maxDepth);
    }
}

