/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.reflection.annotated;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.reflection.annotated.ParameterValueRedefiner;

public class InjectableMethod<X> {
    private final AnnotatedMethod<X> method;
    private final List<InjectionPoint> parameters;
    private final BeanManager beanManager;

    public InjectableMethod(AnnotatedMethod<X> method, Bean<?> declaringBean, BeanManager beanManager) {
        this(method, Beans.createInjectionPoints(method, declaringBean, beanManager), beanManager);
    }

    public InjectableMethod(AnnotatedMethod<X> method, Collection<InjectionPoint> parameters, BeanManager beanManager) {
        this.method = method;
        this.parameters = new ArrayList<InjectionPoint>(parameters);
        this.beanManager = beanManager;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    protected List<InjectionPoint> getParameters() {
        return this.parameters;
    }

    public <T> T invoke(Object receiver, CreationalContext<T> creationalContext) {
        return this.invoke(receiver, creationalContext, null);
    }

    public <T> T invoke(Object receiver, CreationalContext<T> creationalContext, ParameterValueRedefiner redefinition) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (int i = 0; i < this.getParameters().size(); ++i) {
            if (redefinition != null) {
                ParameterValueRedefiner.ParameterValue value = new ParameterValueRedefiner.ParameterValue(i, this.getParameters().get(i), this.getBeanManager());
                parameterValues.add(redefinition.redefineParameterValue(value));
                continue;
            }
            parameterValues.add(this.getBeanManager().getInjectableReference(this.getParameters().get(i), creationalContext));
        }
        Object result = Reflections.invokeMethod((boolean)true, (Method)this.method.getJavaMember(), (Object)receiver, (Object[])parameterValues.toArray(Reflections.EMPTY_OBJECT_ARRAY));
        return (T)result;
    }
}

