/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.mock;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.WicketTester;
import org.jboss.seam.wicket.SeamApplication;
import org.jboss.seam.wicket.mock.SeamTestRequestCycle;
import org.jboss.weld.context.http.HttpRequestContext;

public class SeamWicketTester
extends WicketTester {
    @Inject
    HttpRequestContext requestContext;

    public WebRequestCycle setupRequestAndResponse(boolean isAjax) {
        if (this.requestContext.isActive()) {
            this.endRequest((ServletRequest)this.getServletRequest());
        }
        WebRequestCycle webRequestCycle = super.setupRequestAndResponse(isAjax);
        this.startRequest((ServletRequest)this.getServletRequest());
        return webRequestCycle;
    }

    public void startRequest(ServletRequest servletRequest) {
        this.requestContext.associate((Object)servletRequest);
        this.requestContext.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(ServletRequest servletRequest) {
        try {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
        }
        finally {
            this.requestContext.dissociate((Object)servletRequest);
        }
    }

    public SeamWicketTester() {
        super((WebApplication)new DummySeamApplication());
    }

    public SeamWicketTester(final Class<? extends Page> homePage) {
        super((WebApplication)new SeamApplication(){

            public Class<? extends Page> getHomePage() {
                return homePage;
            }

            protected ISessionStore newSessionStore() {
                return new HttpSessionStore((Application)this);
            }

            protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
                return new WebResponse(servletResponse);
            }

            protected void outputDevelopmentModeWarning() {
            }
        });
    }

    public static class NonPageCachingDummySeamApplication
    extends DummySeamApplication {
        @Override
        protected ISessionStore newSessionStore() {
            return new SecondLevelCacheSessionStore((Application)this, new SecondLevelCacheSessionStore.IPageStore(){

                public void destroy() {
                }

                public Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
                    return null;
                }

                public void pageAccessed(String sessionId, Page page) {
                }

                public void removePage(String sessionId, String pagemap, int id) {
                }

                public void storePage(String sessionId, Page page) {
                }

                public void unbind(String sessionId) {
                }

                public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
                    return false;
                }
            });
        }
    }

    public static class DummySeamApplication
    extends SeamApplication {
        private SeamTestRequestCycle seamTestRequestCycle;
        private boolean manuallyDetach = false;

        public Class<? extends Page> getHomePage() {
            return DummyHomePage.class;
        }

        protected ISessionStore newSessionStore() {
            return new HttpSessionStore((Application)this);
        }

        protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
            return new WebResponse(servletResponse);
        }

        protected void outputDevelopmentModeWarning() {
        }

        public RequestCycle newRequestCycle(Request request, Response response) {
            this.seamTestRequestCycle = new SeamTestRequestCycle((WebApplication)this, (WebRequest)request, (Response)((WebResponse)response), !this.manuallyDetach);
            return this.seamTestRequestCycle;
        }

        public void detach() {
            if (this.seamTestRequestCycle != null) {
                this.seamTestRequestCycle.superDetach();
            }
        }

        public boolean isManuallyDetach() {
            return !this.seamTestRequestCycle.isDetach();
        }

        public void setManuallyDetach(boolean manuallyDetach) {
            this.manuallyDetach = manuallyDetach;
            this.seamTestRequestCycle.setDetach(!manuallyDetach);
        }
    }
}

