/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.util;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.wicket.util.collections.ClassMetaCache;

public class NonContextual<T> {
    private static final ClassMetaCache<NonContextual<?>> cache = new ClassMetaCache();
    private final InjectionTarget<? extends T> injectionTarget;
    private final BeanManager beanManager;

    public static <T> NonContextual<T> of(Class<? extends T> clazz, BeanManager manager) {
        NonContextual<? extends T> nc = (NonContextual<? extends T>)cache.get(clazz);
        if (nc == null) {
            nc = new NonContextual<T>(manager, clazz);
            cache.put(clazz, nc);
        }
        return nc;
    }

    public NonContextual(BeanManager manager, Class<? extends T> clazz) {
        this.beanManager = manager;
        AnnotatedType type = manager.createAnnotatedType(clazz);
        this.injectionTarget = manager.createInjectionTarget(type);
    }

    public Instance<T> newInstance() {
        return new Instance(this.beanManager, this.injectionTarget);
    }

    public Instance<T> existingInstance(T instance) {
        return new Instance(this.beanManager, this.injectionTarget, instance);
    }

    public static class Instance<T> {
        private final CreationalContext<T> ctx;
        private final InjectionTarget<T> injectionTarget;
        private T instance;
        private boolean disposed = false;

        private Instance(BeanManager beanManager, InjectionTarget<T> injectionTarget) {
            this.injectionTarget = injectionTarget;
            this.ctx = beanManager.createCreationalContext(null);
        }

        private Instance(BeanManager beanManager, InjectionTarget<T> injectionTarget, T instance) {
            this.injectionTarget = injectionTarget;
            this.ctx = beanManager.createCreationalContext(null);
            this.instance = instance;
        }

        public T get() {
            return this.instance;
        }

        public Instance<T> produce() {
            if (this.instance != null) {
                throw new IllegalStateException("Trying to call produce() on already constructed instance");
            }
            if (this.disposed) {
                throw new IllegalStateException("Trying to call produce() on an already disposed instance");
            }
            this.instance = this.injectionTarget.produce(this.ctx);
            return this;
        }

        public Instance<T> inject() {
            if (this.instance == null) {
                throw new IllegalStateException("Trying to call inject() before produce() was called");
            }
            if (this.disposed) {
                throw new IllegalStateException("Trying to call inject() on already disposed instance");
            }
            this.injectionTarget.inject(this.instance, this.ctx);
            return this;
        }

        public Instance<T> postConstruct() {
            if (this.instance == null) {
                throw new IllegalStateException("Trying to call postConstruct() before produce() was called");
            }
            if (this.disposed) {
                throw new IllegalStateException("Trying to call preDestroy() on already disposed instance");
            }
            this.injectionTarget.postConstruct(this.instance);
            return this;
        }

        public Instance<T> preDestroy() {
            if (this.instance == null) {
                throw new IllegalStateException("Trying to call preDestroy() before produce() was called");
            }
            if (this.disposed) {
                throw new IllegalStateException("Trying to call preDestroy() on already disposed instance");
            }
            this.injectionTarget.preDestroy(this.instance);
            return this;
        }

        public Instance<T> dispose() {
            if (this.instance == null) {
                throw new IllegalStateException("Trying to call dispose() before produce() was called");
            }
            if (this.disposed) {
                throw new IllegalStateException("Trying to call dispose() on already disposed instance");
            }
            this.injectionTarget.dispose(this.instance);
            this.ctx.release();
            return this;
        }
    }
}

