/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.fieldset;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.xml.fieldset.FieldValue;
import org.jboss.seam.xml.fieldset.FieldValueObject;
import org.jboss.seam.xml.model.EntryXmlItem;
import org.jboss.seam.xml.util.TypeReader;
import org.jboss.weld.extensions.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFieldSet
implements FieldValueObject {
    private final Property<Object> field;
    private final List<Map.Entry<FieldValue, FieldValue>> values;
    private final Class<?> keyType;
    private final Class<?> valueType;
    private final Class<? extends Map> collectionType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapFieldSet(Property<Object> field, List<EntryXmlItem> items) {
        this.field = field;
        this.values = new ArrayList<Map.Entry<FieldValue, FieldValue>>();
        Type type = field.getBaseType();
        if (!(type instanceof ParameterizedType)) throw new RuntimeException("Could not determine element type for map " + field.getDeclaringClass().getName() + "." + field.getName());
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getRawType() == Map.class) {
            this.collectionType = LinkedHashMap.class;
        } else if (parameterizedType.getRawType() == LinkedHashMap.class) {
            this.collectionType = LinkedHashMap.class;
        } else if (parameterizedType.getRawType() == HashMap.class) {
            this.collectionType = HashMap.class;
        } else if (parameterizedType.getRawType() == SortedMap.class) {
            this.collectionType = TreeMap.class;
        } else {
            if (parameterizedType.getRawType() != TreeMap.class) throw new RuntimeException("Could not determine element type for map " + field.getDeclaringClass().getName() + "." + field.getName());
            this.collectionType = TreeMap.class;
        }
        this.keyType = TypeReader.readClassFromType(parameterizedType.getActualTypeArguments()[0]);
        this.valueType = TypeReader.readClassFromType(parameterizedType.getActualTypeArguments()[1]);
        for (EntryXmlItem i : items) {
            this.values.add(new EntryImpl(i.getKey().getValue(), i.getValue().getValue()));
        }
    }

    @Override
    public void setValue(Object instance, CreationalContext<?> ctx, BeanManager manager) {
        try {
            Map res = this.collectionType.newInstance();
            this.field.setValue(instance, (Object)res);
            for (int i = 0; i < this.values.size(); ++i) {
                Map.Entry<FieldValue, FieldValue> e = this.values.get(i);
                res.put(e.getKey().value(this.keyType, ctx, manager), e.getValue().value(this.valueType, ctx, manager));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryImpl
    implements Map.Entry<FieldValue, FieldValue> {
        private FieldValue key;
        private FieldValue value;

        public EntryImpl(FieldValue key, FieldValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public FieldValue getKey() {
            return this.key;
        }

        @Override
        public FieldValue getValue() {
            return this.value;
        }

        @Override
        public FieldValue setValue(FieldValue value) {
            this.value = value;
            return this.value;
        }

        public void setKey(FieldValue key) {
            this.key = key;
        }
    }
}

