/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.xml.model.XmlItem;
import org.jboss.seam.xml.model.XmlItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlItem
implements XmlItem {
    protected final XmlItemType type;
    protected final XmlItem parent;
    protected final Class<?> javaClass;
    protected final String innerText;
    protected final Map<String, String> attributes;
    protected final int lineno;
    protected final String document;
    final List<XmlItem> children = new ArrayList<XmlItem>();

    @Override
    public String getInnerText() {
        return this.innerText;
    }

    public AbstractXmlItem(XmlItemType type, XmlItem parent, Class<?> javaClass, String innerText, Map<String, String> attributes, String document, int lineno) {
        this.type = type;
        this.parent = parent;
        this.javaClass = javaClass;
        this.innerText = innerText;
        this.attributes = attributes == null ? new HashMap<String, String>() : new HashMap<String, String>(attributes);
        this.lineno = lineno;
        this.document = document;
    }

    @Override
    public int getLineno() {
        return this.lineno;
    }

    @Override
    public String getDocument() {
        return this.document;
    }

    @Override
    public void addChild(XmlItem xmlItem) {
        this.children.add(xmlItem);
    }

    @Override
    public XmlItem getParent() {
        return this.parent;
    }

    @Override
    public List<XmlItem> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public XmlItemType getType() {
        return this.type;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean resolveChildren(BeanManager manager) {
        return true;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> List<T> getChildrenOfType(Class<T> type) {
        ArrayList<XmlItem> ret = new ArrayList<XmlItem>();
        for (XmlItem i : this.children) {
            if (!type.isAssignableFrom(i.getClass())) continue;
            ret.add(i);
        }
        return ret;
    }
}

