/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.model;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.xml.model.ClassXmlItem;
import org.jboss.seam.xml.model.ParameterXmlItem;
import org.jboss.seam.xml.model.XmlItem;
import org.jboss.seam.xml.util.XmlConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayXmlItem
extends ParameterXmlItem {
    Class<?> javaClass = null;
    int dimensions = 1;

    public ArrayXmlItem(XmlItem parent, Map<String, String> attributes, String document, int lineno) {
        super(parent, null, document, lineno);
        if (attributes.containsKey("dimensions")) {
            try {
                this.dimensions = Integer.parseInt(attributes.get("dimensions"));
            }
            catch (NumberFormatException e) {
                throw new XmlConfigurationException("dimensions attribute on <array> must be an integer", document, lineno);
            }
        }
    }

    @Override
    public boolean resolveChildren(BeanManager manager) {
        List<ClassXmlItem> classXmlItems = this.getChildrenOfType(ClassXmlItem.class);
        if (classXmlItems.isEmpty()) {
            throw new XmlConfigurationException("<array>  element must have a child specifying the array type", this.getDocument(), this.getLineno());
        }
        if (classXmlItems.size() != 1) {
            throw new XmlConfigurationException("<array>  element must have a single child specifying the array type", this.getDocument(), this.getLineno());
        }
        int[] dims = new int[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            dims[i] = 0;
        }
        Class<?> l = classXmlItems.get(0).getJavaClass();
        this.javaClass = Array.newInstance(l, dims).getClass();
        return true;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }
}

