/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.model;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Qualifier;
import javax.interceptor.InterceptorBinding;
import org.jboss.seam.xml.core.BeanResult;
import org.jboss.seam.xml.core.BeanResultType;
import org.jboss.seam.xml.core.XmlResult;
import org.jboss.seam.xml.model.AnnotationUtils;
import org.jboss.seam.xml.model.AnnotationXmlItem;
import org.jboss.seam.xml.model.ClassXmlItem;
import org.jboss.seam.xml.model.ResultType;
import org.jboss.seam.xml.model.XmlItem;
import org.jboss.seam.xml.model.XmlItemType;
import org.jboss.seam.xml.parser.SaxNode;
import org.jboss.seam.xml.parser.namespace.CompositeNamespaceElementResolver;
import org.jboss.seam.xml.parser.namespace.NamespaceElementResolver;
import org.jboss.seam.xml.parser.namespace.RootNamespaceElementResolver;
import org.jboss.seam.xml.util.TypeOccuranceInformation;
import org.jboss.seam.xml.util.XmlConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder {
    static final String ROOT_NAMESPACE = "urn:java:ee";
    static final String BEANS_ROOT_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    static final Logger log = LoggerFactory.getLogger(ModelBuilder.class);
    private final XmlResult ret;

    public ModelBuilder(String fileUrl) {
        this.ret = new XmlResult(fileUrl);
    }

    public XmlResult build(SaxNode root, BeanManager manager) {
        HashMap<String, NamespaceElementResolver> resolvers = new HashMap<String, NamespaceElementResolver>();
        if (!root.getName().equals("beans")) {
            throw new XmlConfigurationException("Wrong root element for XML config file, expected:<beans> found:" + root.getName(), root.getDocument(), root.getLineNo());
        }
        if (!ROOT_NAMESPACE.equals(root.getNamespaceUri()) && !BEANS_ROOT_NAMESPACE.equals(root.getNamespaceUri())) {
            throw new XmlConfigurationException("Wrong root namespace for XML config file, expected:urn:java:ee or http://java.sun.com/xml/ns/javaee found:" + root.getNamespaceUri(), root.getDocument(), root.getLineNo());
        }
        resolvers.put(ROOT_NAMESPACE, new RootNamespaceElementResolver());
        List<SaxNode> children = root.getChildren();
        for (SaxNode node : children) {
            try {
                XmlItem rb;
                if (node.getNamespaceUri() == null || node.getNamespaceUri().equals(BEANS_ROOT_NAMESPACE) || (rb = this.resolveNode(node, null, resolvers, manager)) == null) continue;
                this.addNodeToResult(rb, manager);
            }
            catch (Exception e) {
                this.ret.addProblem(e.getMessage());
                e.printStackTrace();
            }
        }
        return this.ret;
    }

    public void addNodeToResult(XmlItem xmlItem, BeanManager manager) {
        this.validateXmlItem(xmlItem);
        if (xmlItem.getType() == XmlItemType.CLASS || xmlItem.getType() == XmlItemType.ANNOTATION) {
            ResultType resultType = this.getItemType(xmlItem);
            if (resultType == ResultType.BEAN) {
                ClassXmlItem cxml = (ClassXmlItem)xmlItem;
                BeanResult<?> beanResult = cxml.createBeanResult(manager);
                this.ret.addBean(beanResult);
                if (beanResult.getBeanType() != BeanResultType.ADD) {
                    this.ret.addVeto(beanResult.getType());
                }
            } else if (resultType == ResultType.VIRTUAL_PRODUCER) {
                ClassXmlItem cxml = (ClassXmlItem)xmlItem;
                BeanResult<?> beanResult = cxml.createVirtualFieldBeanResult(manager);
                this.ret.addBean(beanResult);
                if (beanResult.getBeanType() != BeanResultType.ADD) {
                    this.ret.addVeto(beanResult.getType());
                }
            } else if (resultType == ResultType.QUALIFIER) {
                this.ret.addQualifier(xmlItem.getJavaClass());
            } else if (resultType == ResultType.INTERCEPTOR_BINDING) {
                this.ret.addInterceptorBinding(xmlItem.getJavaClass());
            } else if (resultType == ResultType.STEREOTYPE) {
                this.addStereotypeToResult(this.ret, xmlItem);
            }
        }
    }

    protected XmlItem resolveNode(SaxNode node, XmlItem parent, Map<String, NamespaceElementResolver> resolvers, BeanManager manager) {
        NamespaceElementResolver resolver = this.resolveNamepsace(node.getNamespaceUri(), resolvers);
        if (resolver == null) {
            log.warn("Could not resolve namspace for seam-xml: {}", (Object)node.getNamespaceUri());
            return null;
        }
        XmlItem ret = resolver.getItemForNamespace(node, parent);
        if (ret == null) {
            throw new XmlConfigurationException("Could not resolve node " + node.getName() + " in namespace " + node.getNamespaceUri(), node.getDocument(), node.getLineNo());
        }
        List<SaxNode> children = node.getChildren();
        for (SaxNode n : children) {
            if (n.getNamespaceUri() == null) continue;
            XmlItem rb = this.resolveNode(n, ret, resolvers, manager);
            ret.addChild(rb);
        }
        ret.resolveChildren(manager);
        return ret;
    }

    protected NamespaceElementResolver resolveNamepsace(String namespaceURI, Map<String, NamespaceElementResolver> resolvers) {
        if (resolvers.containsKey(namespaceURI)) {
            return resolvers.get(namespaceURI);
        }
        if (!namespaceURI.startsWith("urn:java:")) {
            return null;
        }
        String ns = namespaceURI.replaceFirst("urn:java:", "");
        CompositeNamespaceElementResolver res = new CompositeNamespaceElementResolver(ns.split(":"));
        resolvers.put(namespaceURI, res);
        return res;
    }

    protected ResultType getItemType(XmlItem item) {
        ResultType ret = null;
        for (AnnotationXmlItem it : item.getChildrenOfType(AnnotationXmlItem.class)) {
            if (it.getJavaClass() == InterceptorBinding.class) {
                if (ret != null) {
                    throw new XmlConfigurationException("Element cannot be both an INTERCEPTOR_BINDING and a " + ret.toString(), item.getDocument(), item.getLineno());
                }
                ret = ResultType.INTERCEPTOR_BINDING;
                continue;
            }
            if (it.getJavaClass() == Qualifier.class) {
                if (ret != null) {
                    throw new XmlConfigurationException("Element cannot be both an QUALIFIER and a " + ret.toString(), item.getDocument(), item.getLineno());
                }
                ret = ResultType.QUALIFIER;
                continue;
            }
            if (it.getJavaClass() == Produces.class) {
                if (ret != null) {
                    throw new XmlConfigurationException("Element cannot be both an virtual producer field and a " + ret.toString(), item.getDocument(), item.getLineno());
                }
                ret = ResultType.VIRTUAL_PRODUCER;
                continue;
            }
            if (it.getJavaClass() != Stereotype.class) continue;
            if (ret != null) {
                throw new XmlConfigurationException("Element cannot be both an STEREOTYPE and a " + ret.toString(), item.getDocument(), item.getLineno());
            }
            ret = ResultType.STEREOTYPE;
        }
        if (ret == null) {
            ret = ResultType.BEAN;
        }
        return ret;
    }

    void addStereotypeToResult(XmlResult ret, XmlItem rb) {
        Annotation[] values = new Annotation[rb.getChildren().size()];
        int count = 0;
        for (XmlItem item : rb.getChildren()) {
            Annotation a;
            if (item.getType() != XmlItemType.ANNOTATION) {
                throw new XmlConfigurationException("Setereotype " + rb.getJavaClass() + " has an item that does not represent an annotation in its XML configurations", rb.getDocument(), rb.getLineno());
            }
            values[count] = a = AnnotationUtils.createAnnotation((AnnotationXmlItem)item);
            ++count;
        }
        ret.addStereotype(rb.getJavaClass(), values);
    }

    public void validateXmlItem(XmlItem item) {
        Set<TypeOccuranceInformation> allowed = item.getAllowedItem();
        HashMap<XmlItemType, Integer> counts = new HashMap<XmlItemType, Integer>();
        for (XmlItem i : item.getChildren()) {
            boolean found = false;
            for (TypeOccuranceInformation type : allowed) {
                if (type.getType() != i.getType()) continue;
                found = true;
                if (counts.containsKey((Object)i.getType())) {
                    counts.put(i.getType(), (Integer)counts.get((Object)i.getType()) + 1);
                    continue;
                }
                counts.put(i.getType(), 1);
            }
            if (!found) {
                throw new XmlConfigurationException("Item " + (Object)((Object)item.getType()) + " is not allowed to contain " + (Object)((Object)i.getType()), item.getDocument(), item.getLineno());
            }
            this.validateXmlItem(i);
        }
        for (TypeOccuranceInformation type : allowed) {
            Integer count = (Integer)counts.get((Object)type.getType());
            if (type.getMaxOccurances() != null && count != null && count > type.getMaxOccurances()) {
                throw new XmlConfigurationException("Item " + (Object)((Object)item.getType()) + " has " + count + " children of type " + (Object)((Object)type.getType()) + " when it should have at most " + type.getMaxOccurances(), item.getDocument(), item.getLineno());
            }
            if (type.getMinOccurances() == null || count != null && count >= type.getMinOccurances()) continue;
            throw new XmlConfigurationException("Item " + (Object)((Object)item.getType()) + " has " + count + " children of type " + (Object)((Object)type.getType()) + " when it should have at least " + type.getMinOccurances(), item.getDocument(), item.getLineno());
        }
    }
}

