/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.xml.core.BeanResult;
import org.jboss.seam.xml.fieldset.ArrayFieldSet;
import org.jboss.seam.xml.fieldset.CollectionFieldSet;
import org.jboss.seam.xml.fieldset.ConstantFieldValue;
import org.jboss.seam.xml.fieldset.ELFieldValue;
import org.jboss.seam.xml.fieldset.FieldValue;
import org.jboss.seam.xml.fieldset.FieldValueObject;
import org.jboss.seam.xml.fieldset.MapFieldSet;
import org.jboss.seam.xml.fieldset.SimpleFieldValue;
import org.jboss.seam.xml.model.AbstractXmlItem;
import org.jboss.seam.xml.model.EntryXmlItem;
import org.jboss.seam.xml.model.ValueXmlItem;
import org.jboss.seam.xml.model.XmlItem;
import org.jboss.seam.xml.model.XmlItemType;
import org.jboss.seam.xml.util.Reflections;
import org.jboss.seam.xml.util.TypeOccuranceInformation;
import org.jboss.seam.xml.util.XmlConfigurationException;
import org.jboss.weld.extensions.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyXmlItem
extends AbstractXmlItem {
    private final Property<Object> property;
    private final HashSet<TypeOccuranceInformation> allowed = new HashSet();
    private final Class<?> fieldType;
    private final List<BeanResult<?>> inlineBeans = new ArrayList();
    private FieldValueObject fieldValue;

    public PropertyXmlItem(XmlItem parent, Property<Object> property, String innerText, String document, int lineno) {
        this(parent, property, innerText, null, document, lineno);
    }

    public PropertyXmlItem(XmlItem parent, Property<Object> property, String innerText, Class<?> overridenFieldType, String document, int lineno) {
        super(XmlItemType.FIELD, parent, parent.getJavaClass(), innerText, null, document, lineno);
        this.property = property;
        this.fieldType = overridenFieldType == null ? property.getJavaClass() : overridenFieldType;
        if (innerText != null && innerText.length() > 0) {
            FieldValue fv = innerText.matches("^#\\{.*\\}$") ? new ELFieldValue(innerText) : new ConstantFieldValue(innerText);
            this.fieldValue = new SimpleFieldValue(parent.getJavaClass(), property, fv, this.fieldType);
        }
        this.allowed.add(new TypeOccuranceInformation(XmlItemType.VALUE, null, null));
        this.allowed.add(new TypeOccuranceInformation(XmlItemType.ANNOTATION, null, null));
        this.allowed.add(new TypeOccuranceInformation(XmlItemType.ENTRY, null, null));
    }

    public FieldValueObject getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public boolean resolveChildren(BeanManager manager) {
        ArrayList<EntryXmlItem> mapEntries = new ArrayList<EntryXmlItem>();
        ArrayList<ValueXmlItem> valueEntries = new ArrayList<ValueXmlItem>();
        if (this.fieldValue == null) {
            for (XmlItem i : this.children) {
                if (i.getType() == XmlItemType.VALUE) {
                    valueEntries.add((ValueXmlItem)i);
                    continue;
                }
                if (i.getType() != XmlItemType.ENTRY) continue;
                mapEntries.add((EntryXmlItem)i);
            }
        }
        if (!mapEntries.isEmpty() || !valueEntries.isEmpty()) {
            if (Map.class.isAssignableFrom(this.getFieldType())) {
                if (!valueEntries.isEmpty()) {
                    throw new XmlConfigurationException("Map fields cannot have <value> elements as children,only <entry> elements Field:" + this.getDeclaringClass().getName() + '.' + this.getFieldName(), this.getDocument(), this.getLineno());
                }
                if (!mapEntries.isEmpty()) {
                    for (EntryXmlItem entry : mapEntries) {
                        Set<BeanResult<?>> beans = entry.getBeanResults(manager);
                        this.inlineBeans.addAll(beans);
                    }
                    this.fieldValue = new MapFieldSet(this.property, mapEntries);
                }
            } else if (Collection.class.isAssignableFrom(this.getFieldType()) || this.getFieldType().isArray()) {
                if (!mapEntries.isEmpty()) {
                    throw new XmlConfigurationException("Collection fields must be set using <value> not <entry> Field:" + this.getDeclaringClass().getName() + '.' + this.getFieldName(), this.getDocument(), this.getLineno());
                }
                if (!valueEntries.isEmpty()) {
                    for (ValueXmlItem value : valueEntries) {
                        BeanResult<?> result = value.getBeanResult(manager);
                        if (result == null) continue;
                        this.inlineBeans.add(result);
                    }
                    this.fieldValue = this.getFieldType().isArray() ? new ArrayFieldSet(this.property, valueEntries) : new CollectionFieldSet(this.property, valueEntries);
                }
            } else {
                if (!mapEntries.isEmpty()) {
                    throw new XmlConfigurationException("Only Map fields can be set using <entry> Field:" + this.getDeclaringClass().getName() + '.' + this.getFieldName(), this.getDocument(), this.getLineno());
                }
                if (valueEntries.size() != 1) {
                    throw new XmlConfigurationException("Non collection fields can only have a single <value> element Field:" + this.getDeclaringClass().getName() + '.' + this.getFieldName(), this.getDocument(), this.getLineno());
                }
                ValueXmlItem value = (ValueXmlItem)valueEntries.get(0);
                BeanResult<?> result = value.getBeanResult(manager);
                this.fieldValue = new SimpleFieldValue(this.parent.getJavaClass(), this.property, value.getValue(), this.fieldType);
                if (result != null) {
                    this.inlineBeans.add(result);
                }
            }
        }
        return true;
    }

    public Field getField() {
        if (this.property.getMember() instanceof Field) {
            return (Field)this.property.getMember();
        }
        return Reflections.getField(this.parent.getJavaClass(), this.property.getName());
    }

    @Override
    public Set<TypeOccuranceInformation> getAllowedItem() {
        return this.allowed;
    }

    public Collection<? extends BeanResult<?>> getInlineBeans() {
        return this.inlineBeans;
    }

    public Class<?> getDeclaringClass() {
        return this.property.getDeclaringClass();
    }

    public String getFieldName() {
        return this.property.getName();
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public Property<?> getProperty() {
        return this.property;
    }
}

