/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.parser.namespace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.xml.model.AnnotationXmlItem;
import org.jboss.seam.xml.model.ClassXmlItem;
import org.jboss.seam.xml.model.MethodXmlItem;
import org.jboss.seam.xml.model.ParameterXmlItem;
import org.jboss.seam.xml.model.PropertyXmlItem;
import org.jboss.seam.xml.model.XmlItem;
import org.jboss.seam.xml.model.XmlItemType;
import org.jboss.seam.xml.parser.SaxNode;
import org.jboss.seam.xml.parser.namespace.NamespaceElementResolver;
import org.jboss.seam.xml.util.PropertyUtils;
import org.jboss.seam.xml.util.TypeOccuranceInformation;
import org.jboss.weld.extensions.properties.Property;
import org.jboss.weld.extensions.properties.query.NamedPropertyCriteria;
import org.jboss.weld.extensions.properties.query.PropertyCriteria;
import org.jboss.weld.extensions.properties.query.PropertyQueries;
import org.jboss.weld.extensions.properties.query.PropertyQuery;
import org.jboss.weld.extensions.reflection.Reflections;

public class PackageNamespaceElementResolver
implements NamespaceElementResolver {
    private final String pack;
    private final Map<String, Class<?>> cache = new HashMap();
    private final Set<String> notFound = new HashSet<String>();

    public PackageNamespaceElementResolver(String pack) {
        this.pack = pack + ".";
    }

    public XmlItem getItemForNamespace(SaxNode node, XmlItem parent) {
        String name = node.getName();
        if (this.notFound.contains(name)) {
            return null;
        }
        try {
            Class<?> c;
            if (this.cache.containsKey(name)) {
                c = this.cache.get(name);
            } else {
                c = this.getClass().getClassLoader().loadClass(this.pack + name);
                this.cache.put(name, c);
            }
            if (c.isAnnotation()) {
                return new AnnotationXmlItem(parent, c, node.getInnerText(), node.getAttributes(), node.getDocument(), node.getLineNo());
            }
            if (parent != null && parent.getType() == XmlItemType.PARAMETERS) {
                return new ParameterXmlItem(parent, c, node.getDocument(), node.getLineNo());
            }
            return new ClassXmlItem(parent, c, node.getAttributes(), node.getDocument(), node.getLineNo());
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        if (parent != null) {
            if (TypeOccuranceInformation.isTypeInSet(parent.getAllowedItem(), XmlItemType.METHOD) || TypeOccuranceInformation.isTypeInSet(parent.getAllowedItem(), XmlItemType.FIELD)) {
                return PackageNamespaceElementResolver.resolveMethodOrField(name, parent, node);
            }
            this.notFound.add(name);
        } else {
            this.notFound.add(name);
        }
        return null;
    }

    public static XmlItem resolveMethodOrField(String name, XmlItem parent, SaxNode node) {
        Class<?> p = parent.getJavaClass();
        boolean methodFound = Reflections.methodExists(p, (String)name);
        PropertyQuery query = PropertyQueries.createQuery(parent.getJavaClass());
        query.addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{name}));
        Property property = query.getFirstResult();
        if (methodFound && property != null) {
            for (SaxNode child : node.getChildren()) {
                if (!child.getName().equals(XmlItemType.PARAMETERS.getElementName())) continue;
                property = null;
            }
            if (property != null) {
                methodFound = false;
            }
        }
        if (methodFound) {
            return new MethodXmlItem(parent, name, node.getDocument(), node.getLineNo());
        }
        if (property != null) {
            PropertyUtils.setAccessible(property);
            return new PropertyXmlItem(parent, (Property<Object>)property, node.getInnerText(), null, node.getDocument(), node.getLineNo());
        }
        return null;
    }
}

