/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.xml.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;

public class XmlObjectConverter {
    public static Object convert(Class target, String value) {
        if (target == String.class) {
            return value;
        }
        if (target.isEnum()) {
            return Enum.valueOf(target, value);
        }
        if (target == Class.class) {
            try {
                return XmlObjectConverter.class.getClassLoader().loadClass(value);
            }
            catch (ClassNotFoundException e) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(value);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Could not set field value to class configured in XML: " + value, e1);
                }
            }
        }
        if (Date.class == target) {
            try {
                java.util.Date dval = DateFormat.getDateTimeInstance().parse(value);
                return new Date(dval.getYear(), dval.getMonth(), dval.getDay());
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse javax.sql.Date field value: " + value, e);
            }
        }
        if (Time.class == target) {
            try {
                java.util.Date dval = DateFormat.getDateTimeInstance().parse(value);
                return new Time(dval.getHours(), dval.getMinutes(), dval.getSeconds());
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse javax.sql.Date field value: " + value, e);
            }
        }
        if (Timestamp.class == target) {
            try {
                java.util.Date dval = DateFormat.getDateTimeInstance().parse(value);
                return new Timestamp(dval.getYear(), dval.getMonth(), dval.getDay(), dval.getHours(), dval.getMinutes(), dval.getSeconds(), 0);
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse javax.sql.Date field value: " + value, e);
            }
        }
        if (Calendar.class == target) {
            try {
                java.util.Date dval = DateFormat.getDateTimeInstance().parse(value);
                Calendar val = Calendar.getInstance();
                val.setTime(dval);
                return val;
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse Calendar field value: " + value, e);
            }
        }
        if (java.util.Date.class == target) {
            try {
                return DateFormat.getDateTimeInstance().parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse Calendar field value: " + value, e);
            }
        }
        if (target == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (target == BigInteger.class) {
            return new BigInteger(value);
        }
        if (target == Character.TYPE || target == Character.class) {
            if (value.length() != 1) {
                throw new RuntimeException("Value of a char field must be exactly 1 character long");
            }
            return new Character(value.charAt(0));
        }
        if (target == Integer.TYPE || target == Integer.class) {
            return Integer.parseInt(value);
        }
        if (target == Short.TYPE || target == Short.class) {
            return new Short(value);
        }
        if (target == Long.TYPE || target == Long.class) {
            return new Long(value);
        }
        if (target == Byte.TYPE || target == Byte.TYPE) {
            return new Byte(value);
        }
        if (target == Double.TYPE || target == Double.class) {
            return new Double(value);
        }
        if (target == Float.TYPE || target == Float.class) {
            return new Float(value);
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return new Boolean(value);
        }
        throw new RuntimeException("Could not convert value " + value + " to " + target.getName());
    }
}

