/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.idtrust.api.factories;

import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.idtrust.api.plugins.IDTrustSecurityManagement;

/**
 * Security Factory
 * This is the main factory for IDtrust
 * <a href="mailto:anil.saldhana@redhat.com>Anil Saldhana</a>
 */
public class SecurityFactory
{
   private static ISecurityManagement securityManagement = 
      new IDTrustSecurityManagement();
   
   public static AuthenticationManager getAuthenticationManager(String securityDomain)
   {
      validate();
      return securityManagement.getAuthenticationManager(securityDomain);
   }
   
   public static AuthorizationManager getAuthorizationManager(String securityDomain)
   {
      validate();
      return securityManagement.getAuthorizationManager(securityDomain);
   }
   
   public static AuditManager getAuditManager(String securityDomain)
   {
      validate();
      return securityManagement.getAuditManager(securityDomain);
   }
   
   public static ISecurityManagement getSecurityManagement()
   {
      return securityManagement;
   }
   
   public static void setSecurityManagement(ISecurityManagement iSecurityManagement)
   {
      securityManagement = iSecurityManagement;
   }
   
   private static void validate()
   {
      assert(securityManagement != null);
   }
}