/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.microcontainer.beans.AuditPolicyBean;
import org.jboss.security.microcontainer.beans.AuthorizationPolicyBean;
import org.jboss.security.microcontainer.beans.BaseAuthenticationPolicy;
import org.jboss.security.microcontainer.beans.IdentityTrustPolicyBean;
import org.jboss.security.microcontainer.beans.RoleMappingPolicyBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPolicyBean {
    private static final String DEFAULT_NAME = "other";
    private String name = "other";
    private String parentPolicy;
    private BaseAuthenticationPolicy<?> authenticationPolicy;
    private AuthorizationPolicyBean authorizationPolicy;
    private RoleMappingPolicyBean roleMappingPolicy;
    private AuditPolicyBean auditPolicy;
    private IdentityTrustPolicyBean identityTrustPolicy;
    private ISecurityManagement securityManagement;
    protected static Logger logger = Logger.getLogger(ApplicationPolicyBean.class);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentPolicy() {
        return this.parentPolicy;
    }

    public void setParentPolicy(String parentPolicy) {
        this.parentPolicy = parentPolicy;
    }

    public BaseAuthenticationPolicy<?> getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    public void setAuthenticationPolicy(BaseAuthenticationPolicy<?> authenticationPolicy) {
        this.authenticationPolicy = authenticationPolicy;
    }

    public AuthorizationPolicyBean getAuthorizationPolicy() {
        return this.authorizationPolicy;
    }

    public void setAuthorizationPolicy(AuthorizationPolicyBean authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy;
    }

    public RoleMappingPolicyBean getRoleMappingPolicy() {
        return this.roleMappingPolicy;
    }

    public void setRoleMappingPolicy(RoleMappingPolicyBean roleMappingPolicy) {
        this.roleMappingPolicy = roleMappingPolicy;
    }

    public AuditPolicyBean getAuditPolicy() {
        return this.auditPolicy;
    }

    public void setAuditPolicy(AuditPolicyBean auditPolicy) {
        this.auditPolicy = auditPolicy;
    }

    public IdentityTrustPolicyBean getIdentityTrustPolicy() {
        return this.identityTrustPolicy;
    }

    public void setIdentityTrustPolicy(IdentityTrustPolicyBean identityTrustPolicy) {
        this.identityTrustPolicy = identityTrustPolicy;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    public AuthenticationManager getAuthenticationManager() {
        AuthenticationManager manager = null;
        if (this.securityManagement != null) {
            manager = this.securityManagement.getAuthenticationManager(this.name);
        }
        return manager;
    }

    public AuthorizationManager getAuthorizationManager() {
        AuthorizationManager manager = null;
        if (this.securityManagement != null) {
            manager = this.securityManagement.getAuthorizationManager(this.name);
        }
        return manager;
    }

    public MappingManager getMappingManager() {
        MappingManager manager = null;
        if (this.securityManagement != null) {
            manager = this.securityManagement.getMappingManager(this.name);
        }
        return manager;
    }

    public AuditManager getAuditManager() {
        AuditManager manager = null;
        if (this.securityManagement != null) {
            manager = this.securityManagement.getAuditManager(this.name);
        }
        return manager;
    }

    public IdentityTrustManager getIdentityTrustManager() {
        IdentityTrustManager manager = null;
        if (this.securityManagement != null) {
            manager = this.securityManagement.getIdentityTrustManager(this.name);
        }
        return manager;
    }

    public void start() throws Exception {
        ApplicationPolicy policy = this.getApplicationPolicy();
        logger.trace((Object)("ApplicationPolicy " + this.name + " created " + policy));
        XMLLoginConfigImpl policyRegistration = XMLLoginConfigImpl.getInstance();
        policyRegistration.addApplicationPolicy(this.name, policy);
        logger.trace((Object)("ApplicationPolicy " + this.name + " registered"));
    }

    public void stop() throws Exception {
        XMLLoginConfigImpl.getInstance().removeApplicationPolicy(this.name);
        logger.trace((Object)("ApplicationPolicy " + this.name + " removed"));
    }

    public ApplicationPolicy getApplicationPolicy() {
        ApplicationPolicy policy = new ApplicationPolicy(this.name);
        policy.setBaseApplicationPolicyName(this.parentPolicy);
        if (this.authenticationPolicy != null) {
            policy.setAuthenticationInfo(this.authenticationPolicy.getPolicyInfo(this.name));
        }
        if (this.authorizationPolicy != null) {
            policy.setAuthorizationInfo(this.authorizationPolicy.getPolicyInfo(this.name));
        }
        if (this.roleMappingPolicy != null) {
            policy.setRoleMappingInfo((MappingInfo)this.roleMappingPolicy.getPolicyInfo(this.name));
        }
        if (this.auditPolicy != null) {
            policy.setAuditInfo(this.auditPolicy.getPolicyInfo(this.name));
        }
        if (this.identityTrustPolicy != null) {
            policy.setIdentityTrustInfo(this.identityTrustPolicy.getPolicyInfo(this.name));
        }
        return policy;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Application Policy Contents: " + this.name + "\n\n");
        if (this.authenticationPolicy != null) {
            buffer.append(this.authenticationPolicy.toString());
        }
        return buffer.toString();
    }
}

