/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.microcontainer.beans.BaseAuthenticationPolicy;
import org.jboss.security.microcontainer.beans.LoginModuleStackBean;
import org.jboss.security.microcontainer.beans.StackRefPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JASPIAuthenticationPolicyBean
extends BaseAuthenticationPolicy<StackRefPolicyModule> {
    private List<LoginModuleStackBean> moduleStacks = new ArrayList<LoginModuleStackBean>();

    public List<LoginModuleStackBean> getModuleStacks() {
        return this.moduleStacks;
    }

    public void setModuleStacks(List<LoginModuleStackBean> moduleStacks) {
        this.moduleStacks = moduleStacks;
    }

    @Override
    public BaseAuthenticationInfo getPolicyInfo(String domainName) {
        JASPIAuthenticationInfo info = new JASPIAuthenticationInfo(domainName);
        HashMap<String, LoginModuleStackHolder> stackMap = new HashMap<String, LoginModuleStackHolder>();
        for (LoginModuleStackBean stackBean : this.moduleStacks) {
            LoginModuleStackHolder holder = stackBean.getLoginModuleStackHolder();
            info.add(holder);
            stackMap.put(stackBean.getName(), holder);
        }
        for (StackRefPolicyModule module : this.modules) {
            AuthModuleEntry entry = new AuthModuleEntry(module.getCode(), module.getOptions(), module.getStackRef());
            entry.setLoginModuleStackHolder((LoginModuleStackHolder)stackMap.get(module.getStackRef()));
            info.add(entry);
        }
        return info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("JASPI-Authentication Policy:\n");
        for (int i = 0; i < this.modules.size(); ++i) {
            StackRefPolicyModule module = (StackRefPolicyModule)this.modules.get(i);
            buffer.append("Module[" + i + "]\n");
            buffer.append(module.toString());
        }
        for (LoginModuleStackBean stackBean : this.moduleStacks) {
            buffer.append(stackBean.toString());
        }
        return buffer.toString();
    }
}

