/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.microcontainer.beans;

import org.jboss.security.config.ControlFlag;

/**
 * <p>
 * Utility class used by the policies beans.
 * </p>
 * 
 * @author <a href="mailto:sguilhen@redhat.com">Stefan Guilhen</a>
 */
public class Util
{

   /**
    * <p>
    * Converts the specified flag to one of the existing {@code ControlFlag} objects.
    * </p>
    * 
    * @param flag a {@code String} containing the name of the control flag.
    * @return the constructed {@code ControlFlag} object.
    * @throws IllegalArgumentException if the specified flag does not correspond to any {@code ControlFlag}.
    */
   public static ControlFlag getControlFlag(String flag)
   {
      flag = flag.toUpperCase();
      if ("REQUIRED".equals(flag))
         return ControlFlag.REQUIRED;
      else if ("REQUISITE".equals(flag))
         return ControlFlag.REQUISITE;
      else if ("OPTIONAL".equals(flag))
         return ControlFlag.OPTIONAL;
      else if ("SUFFICIENT".equals(flag))
         return ControlFlag.SUFFICIENT;
      else
         throw new IllegalArgumentException("Invalid control flag: " + flag);
   }
}
