/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.microcontainer.beans.BasePolicyBean;
import org.jboss.security.microcontainer.beans.FlaggedPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityTrustPolicyBean
extends BasePolicyBean<FlaggedPolicyModule, IdentityTrustInfo> {
    @Override
    public IdentityTrustInfo getPolicyInfo(String domainName) {
        IdentityTrustInfo info = new IdentityTrustInfo(domainName);
        for (FlaggedPolicyModule module : this.modules) {
            IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(module.getCode(), module.getOptions());
            entry.setControlFlag(ControlFlag.valueOf((String)module.getFlag()));
            info.add((Object)entry);
        }
        return info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Identity-Trust Policy:\n");
        for (int i = 0; i < this.modules.size(); ++i) {
            FlaggedPolicyModule module = (FlaggedPolicyModule)this.modules.get(i);
            buffer.append("Module[" + i + "]\n");
            buffer.append(module.toString());
        }
        return buffer.toString();
    }
}

