/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.microcontainer.beans.BasePolicyBean;
import org.jboss.security.microcontainer.beans.FlaggedPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLPolicyBean
extends BasePolicyBean<FlaggedPolicyModule, ACLInfo> {
    @Override
    public ACLInfo getPolicyInfo(String domainName) {
        ACLInfo info = new ACLInfo(domainName);
        for (FlaggedPolicyModule module : this.modules) {
            ACLProviderEntry entry = new ACLProviderEntry(module.getCode(), module.getOptions());
            entry.setControlFlag(ControlFlag.valueOf((String)module.getFlag()));
            info.add((Object)entry);
        }
        return info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ACL Policy:\n");
        for (int i = 0; i < this.modules.size(); ++i) {
            FlaggedPolicyModule module = (FlaggedPolicyModule)this.modules.get(i);
            buffer.append("Module[" + i + "]\n");
            buffer.append(module.toString());
        }
        return buffer.toString();
    }
}

