/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.microcontainer.beans.BasePolicyBean;
import org.jboss.security.microcontainer.beans.FlaggedPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationPolicyBean
extends BasePolicyBean<FlaggedPolicyModule, AuthorizationInfo> {
    @Override
    public AuthorizationInfo getPolicyInfo(String domainName) {
        AuthorizationInfo info = new AuthorizationInfo(domainName);
        for (FlaggedPolicyModule module : this.modules) {
            AuthorizationModuleEntry entry = new AuthorizationModuleEntry(module.getCode(), module.getOptions());
            entry.setControlFlag(ControlFlag.valueOf((String)module.getFlag()));
            info.add((Object)entry);
        }
        return info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Authorization Policy:\n");
        for (int i = 0; i < this.modules.size(); ++i) {
            FlaggedPolicyModule module = (FlaggedPolicyModule)this.modules.get(i);
            buffer.append("Module[" + i + "]\n");
            buffer.append(module.toString());
        }
        return buffer.toString();
    }
}

