/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.set.channel.cli.MavenBasedCommand;
import org.jboss.set.channel.cli.report.FormattingReportBuilder;
import org.jboss.set.channel.cli.utils.ConversionUtils;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Stream;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import picocli.CommandLine;

@CommandLine.Command(name="compare-channels", description={"Generates report that identifies intersecting streams of two given channels, and highlights streams where their versions differ."})
public class CompareChannelsCommand
extends MavenBasedCommand {
    @CommandLine.Parameters(index="0", description={"Base channel coordinate (URL of GAV)"}, paramLabel="channelCoordinate")
    private String baseChannelCoordinate;
    @CommandLine.Parameters(index="1", description={"Comparison channel coordinate (URL or GAV)"}, paramLabel="channelCoordinate")
    private String targetChannelCoordinate;
    @CommandLine.Option(names={"--channel-repositories"}, description={"Comma separated repositories URLs where the channels should be looked for"}, split=",", paramLabel="URL")
    private List<String> channelRepositoriesUrls;

    @Override
    public Integer call() throws Exception {
        ChannelCoordinate baseCoordinate = ConversionUtils.toChannelCoordinate(this.baseChannelCoordinate);
        ChannelCoordinate targetCoordinate = ConversionUtils.toChannelCoordinate(this.targetChannelCoordinate);
        List<RemoteRepository> channelRepositories = ConversionUtils.toRepositoryList(this.channelRepositoriesUrls);
        try (VersionResolverFactory resolverFactory = new VersionResolverFactory(this.system, (RepositorySystemSession)this.systemSession);){
            List baseChannels = resolverFactory.resolveChannels(List.of(baseCoordinate), channelRepositories);
            List targetChannels = resolverFactory.resolveChannels(List.of(targetCoordinate), channelRepositories);
            ChannelSession baseChannelSession = new ChannelSession(baseChannels, (MavenVersionsResolver.Factory)resolverFactory);
            ChannelSession targetChannelSession = new ChannelSession(targetChannels, (MavenVersionsResolver.Factory)resolverFactory);
            Set<Stream> baseStreams = CompareChannelsCommand.resolveStreams(baseChannels, resolverFactory);
            ArrayList<Pair<MavenArtifact, List<String>>> diff = new ArrayList<Pair<MavenArtifact, List<String>>>();
            for (Stream stream : baseStreams) {
                try {
                    MavenArtifact baseArtifact = baseChannelSession.resolveMavenArtifact(stream.getGroupId(), stream.getArtifactId(), "pom", null, null);
                    MavenArtifact targetArtifact = targetChannelSession.resolveMavenArtifact(stream.getGroupId(), stream.getArtifactId(), "pom", null, null);
                    if (!baseArtifact.getVersion().equals(targetArtifact.getVersion())) {
                        diff.add((Pair<MavenArtifact, List<String>>)Pair.of((Object)baseArtifact, List.of(targetArtifact.getVersion())));
                        System.out.printf("%s:%s:%s -> %s%n", baseArtifact.getGroupId(), baseArtifact.getArtifactId(), baseArtifact.getVersion(), targetArtifact.getVersion());
                    }
                }
                catch (RuntimeException e) {
                    logger.errorf((Throwable)e, "Failure to compare stream %s", (Object)stream);
                }
                if (!stream.getGroupId().contains("opensaml")) continue;
                break;
            }
            List<Repository> targetRepositories = targetChannels.stream().flatMap(ch -> ch.getRepositories().stream()).toList();
            String reportHtml = new FormattingReportBuilder().withRepositories(targetRepositories).withUpgrades(diff).build();
            Files.write(Path.of("report.html", new String[0]), reportHtml.getBytes(), new OpenOption[0]);
            Integer n = 0;
            return n;
        }
    }
}

