/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli;

import java.net.URL;
import java.util.List;
import org.jboss.set.channel.cli.MavenBasedCommand;
import org.jboss.set.channel.cli.utils.ConversionUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.ChannelCoordinate;
import picocli.CommandLine;

@CommandLine.Command(name="extract-manifest-url", description={"Extract manifest URL from given channel. If the manifest coordinate is a Maven GAV, it will be resolved to a local maven cache and the URL will point there."})
public class ExtractManifestUrlCommand
extends MavenBasedCommand {
    @CommandLine.Parameters(index="0", description={"Channel coordinate (URL or GAV)"}, paramLabel="channelCoordinate")
    private String channelCoord;
    @CommandLine.Option(names={"--repositories"}, split=",", description={"Comma separated repositories URLs where the channel files should be looked for, if they need to be resolved via maven."}, paramLabel="URL")
    private List<String> repositoryUrls;

    @Override
    public Integer call() {
        ChannelCoordinate coordinate = ConversionUtils.toChannelCoordinate(this.channelCoord);
        List<Repository> repositories = ConversionUtils.toChannelRepositoryList(this.repositoryUrls);
        Channel channel = this.resolveChannel(coordinate, repositories);
        URL url = this.resolveManifestUrl(channel.getManifestCoordinate(), repositories);
        System.out.println(url.toExternalForm());
        return 0;
    }
}

