/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.set.channel.cli.MavenBasedCommand;
import org.jboss.set.channel.cli.report.FormattingReportBuilder;
import org.jboss.set.channel.cli.utils.ConversionUtils;
import org.jboss.set.channel.cli.utils.IOUtils;
import org.jboss.set.channel.cli.utils.VersionUtils;
import org.wildfly.channel.Blocklist;
import org.wildfly.channel.BlocklistCoordinate;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Stream;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import picocli.CommandLine;

@CommandLine.Command(name="find-upgrades", description={"Generates report showing possible upgrades for streams in given channel by directly querying given Maven repositories. This also generates two manifest files, diff-manifest.yaml and upgraded-manifest.yaml, containing upgraded streams and all streams with upgraded versions respectively."})
public class FindUpgradesCommand
extends MavenBasedCommand {
    private final Path REPORT_FILE = Path.of("report.html", new String[0]);
    private final Path DIFF_MANIFEST_FILE = Path.of("diff-manifest.yaml", new String[0]);
    private final Path UPGRADED_MANIFEST_FILE = Path.of("upgraded-manifest.yaml", new String[0]);
    @CommandLine.Parameters(index="0", description={"Base channel coordinate (URL of GAV)."}, paramLabel="channelCoordinate")
    private String channelCoordinateString;
    @CommandLine.Option(names={"--channel-repositories"}, split=",", description={"Comma separated repositories URLs where the channels should be looked for, if a channel GAV is given."}, paramLabel="URL")
    private List<String> channelRepositoriesUrls;
    @CommandLine.Option(names={"--repositories"}, split=",", required=true, description={"Comma separated repositories URLs where component upgrades should be looked for. Format is either `URL1,URL2,...` or `ID1::URL1,ID2::URL2,...`"}, paramLabel="URL")
    private List<String> repositoryUrls;
    @CommandLine.Option(names={"--include-pattern"}, description={"Regexp that versions need to match in order to be added to the report."})
    private String versionsInclude;
    @CommandLine.Option(names={"--exclude-pattern"}, description={"Regexp to exclude versions from being added to the report."})
    private String versionsExclude;
    @CommandLine.Option(names={"--blocklist-coordinate"}, description={"Blocklist coordinate (URL or GAV)"}, paramLabel="blocklistCoordinate")
    private String blocklistCoordinateString;
    private final ArrayList<Pair<MavenArtifact, List<String>>> upgrades = new ArrayList();
    private final Set<Stream> diffStreams = new HashSet<Stream>();
    private final Set<Stream> upgradedStreams = new HashSet<Stream>();
    private final List<UpgradeDiscoveryListener> discoveryListeners = new ArrayList<UpgradeDiscoveryListener>();
    private final Map<MavenArtifact, Map<String, String>> artifactsToRepositories = new HashMap<MavenArtifact, Map<String, String>>();
    private final List<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
    private final List<RemoteRepository> channelRepositories = new ArrayList<RemoteRepository>();
    private final List<Blocklist> blocklists = new ArrayList<Blocklist>();

    public FindUpgradesCommand() {
        this.discoveryListeners.add(new UpgradeCollectingListener());
        this.discoveryListeners.add(new StreamCollectingListener());
    }

    @Override
    public Integer call() throws Exception {
        ChannelCoordinate channelCoordinate = ConversionUtils.toChannelCoordinate(this.channelCoordinateString);
        this.channelRepositories.addAll(ConversionUtils.toRepositoryList(this.channelRepositoriesUrls));
        this.repositories.addAll(ConversionUtils.toRepositoryList(this.repositoryUrls));
        Pattern inclusionPattern = null;
        Pattern exclusionPattern = null;
        if (this.versionsInclude != null) {
            inclusionPattern = Pattern.compile(this.versionsInclude);
        }
        if (this.versionsExclude != null) {
            exclusionPattern = Pattern.compile(this.versionsExclude);
        }
        try (VersionResolverFactory resolverFactory = new VersionResolverFactory(this.system, (RepositorySystemSession)this.systemSession);){
            List channels = resolverFactory.resolveChannels(List.of(channelCoordinate), this.channelRepositories);
            this.loadBlocklist(resolverFactory, channels);
            ChannelSession channelSession = new ChannelSession(channels, (MavenVersionsResolver.Factory)resolverFactory);
            Set<Stream> channelStreams = FindUpgradesCommand.resolveStreams(channels, resolverFactory);
            this.upgradedStreams.addAll(channelStreams);
            for (Stream stream : channelStreams) {
                MavenArtifact resolvedArtifact = channelSession.resolveMavenArtifact(stream.getGroupId(), stream.getArtifactId(), "pom", null, null);
                VersionRangeResult versionRangeResult = this.resolveVersionRange(resolvedArtifact);
                List availableVersions = versionRangeResult.getVersions().stream().sorted(Comparator.reverseOrder()).toList();
                List<String> possibleUpgrades = FindUpgradesCommand.findPossibleUpgrades(stream, availableVersions, inclusionPattern, exclusionPattern, this.blocklists);
                for (Version version : availableVersions) {
                    ArtifactRepository repository = versionRangeResult.getRepository(version);
                    this.artifactsToRepositories.compute(resolvedArtifact, (a, current) -> {
                        if (current == null) {
                            current = new HashMap<String, String>();
                        }
                        current.put(version.toString(), repository.getId());
                        return current;
                    });
                }
                if (possibleUpgrades.isEmpty()) continue;
                MavenArtifact a2 = resolvedArtifact;
                logger.infof("Found upgrades: %s:%s:%s -> %s", new Object[]{a2.getGroupId(), a2.getArtifactId(), a2.getVersion(), String.join((CharSequence)", ", possibleUpgrades)});
                for (UpgradeDiscoveryListener listener : this.discoveryListeners) {
                    listener.upgrade(resolvedArtifact, possibleUpgrades);
                }
            }
        }
        if (this.upgrades.isEmpty()) {
            return 0;
        }
        this.writeReportFile();
        IOUtils.writeManifestFile(this.DIFF_MANIFEST_FILE, this.diffStreams);
        IOUtils.writeManifestFile(this.UPGRADED_MANIFEST_FILE, this.upgradedStreams);
        return 0;
    }

    private VersionRangeResult resolveVersionRange(MavenArtifact artifact) throws RepositoryException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        DefaultArtifact requestArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), "(" + artifact.getVersion() + ",)");
        rangeRequest.setArtifact((Artifact)requestArtifact);
        rangeRequest.setRepositories(this.repositories);
        VersionRangeResult rangeResult = this.system.resolveVersionRange((RepositorySystemSession)this.systemSession, rangeRequest);
        for (Exception e : rangeResult.getExceptions()) {
            logger.debugf("Version resolution exception: %s", (Object)e.getMessage());
        }
        return rangeResult;
    }

    private void writeReportFile() throws IOException {
        List<Repository> discoveryRepositories = ConversionUtils.toChannelRepositories(this.repositories);
        String reportHtml = new FormattingReportBuilder().withRepositories(discoveryRepositories).withUpgrades(this.upgrades).withArtifactToRepositoryMap(this.artifactsToRepositories).build();
        logger.infof("Writing report file into %s", (Object)this.REPORT_FILE.toString());
        Files.write(this.REPORT_FILE, reportHtml.getBytes(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    private void loadBlocklist(VersionResolverFactory resolverFactory, List<Channel> channels) {
        try (MavenVersionsResolver resolver = resolverFactory.create(ConversionUtils.toChannelRepositories(this.channelRepositories));){
            if (!StringUtils.isBlank((CharSequence)this.blocklistCoordinateString)) {
                BlocklistCoordinate coordinate = ConversionUtils.toBlocklistCoordinate(this.blocklistCoordinateString);
                this.blocklists.addAll(this.resolveBlocklists(resolver, coordinate));
            } else {
                List<BlocklistCoordinate> blocklistCoordinates = channels.stream().map(Channel::getBlocklistCoordinate).toList();
                for (BlocklistCoordinate coordinate : blocklistCoordinates) {
                    this.blocklists.addAll(this.resolveBlocklists(resolver, coordinate));
                }
            }
        }
    }

    private List<Blocklist> resolveBlocklists(MavenVersionsResolver resolver, BlocklistCoordinate coordinate) {
        List urls = resolver.resolveChannelMetadata(List.of(coordinate));
        return urls.stream().map(Blocklist::from).toList();
    }

    static List<String> findPossibleUpgrades(Stream stream, List<? extends Version> versions, Pattern include, Pattern exclude, List<Blocklist> blocklists) {
        HashSet blockedVersions = new HashSet();
        if (blocklists != null) {
            for (Blocklist blocklist : blocklists) {
                blockedVersions.addAll(blocklist.getVersionsFor(stream.getGroupId(), stream.getArtifactId()));
            }
        }
        if ((versions = versions.stream().filter(v -> include == null || include.matcher(v.toString()).find()).filter(v -> exclude == null || !exclude.matcher(v.toString()).find()).filter(v -> !blockedVersions.contains(v.toString())).toList()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> resultVersions = new ArrayList<String>();
        String highestVersion = versions.get(0).toString();
        resultVersions.add(highestVersion);
        String[] lastSegments = VersionUtils.parseVersion(highestVersion);
        String[] lastNumericalSegments = VersionUtils.numericalSegments(lastSegments);
        String lastQualifier = VersionUtils.firstQualifierSegment(lastSegments);
        int lastIndex = lastNumericalSegments.length - 1;
        for (Version version : versions) {
            String[] segments = VersionUtils.parseVersion(version.toString());
            String[] numericalSegments = VersionUtils.numericalSegments(segments);
            String qualifier = VersionUtils.firstQualifierSegment(segments);
            boolean differs = false;
            for (int i = 0; i < lastIndex; ++i) {
                if (i < numericalSegments.length && numericalSegments[i].equals(lastNumericalSegments[i])) continue;
                differs = true;
                break;
            }
            if (!qualifier.equals(lastQualifier) || segments.length != lastSegments.length) {
                differs = true;
            }
            if (!differs) continue;
            resultVersions.add(version.toString());
            lastSegments = segments;
            lastNumericalSegments = numericalSegments;
            lastQualifier = qualifier;
            lastIndex = numericalSegments.length - 1;
        }
        Collections.reverse(resultVersions);
        return resultVersions;
    }

    private class UpgradeCollectingListener
    implements UpgradeDiscoveryListener {
        private UpgradeCollectingListener() {
        }

        @Override
        public void upgrade(MavenArtifact artifact, List<String> possibleUpgrades) {
            FindUpgradesCommand.this.upgrades.add((Pair<MavenArtifact, List<String>>)Pair.of((Object)artifact, possibleUpgrades));
        }
    }

    private class StreamCollectingListener
    implements UpgradeDiscoveryListener {
        private StreamCollectingListener() {
        }

        @Override
        public void upgrade(MavenArtifact artifact, List<String> possibleUpgrades) {
            Optional<String> latestMicro = VersionUtils.findMicroUpgrade(artifact.getVersion(), possibleUpgrades);
            if (latestMicro.isPresent()) {
                FindUpgradesCommand.this.diffStreams.add(new Stream(artifact.getGroupId(), artifact.getArtifactId(), latestMicro.get()));
                Optional<Stream> originalStream = FindUpgradesCommand.this.upgradedStreams.stream().filter(s -> s.getGroupId().equals(artifact.getGroupId()) && s.getArtifactId().equals(artifact.getArtifactId())).findAny();
                if (originalStream.isPresent()) {
                    FindUpgradesCommand.this.upgradedStreams.remove(originalStream.get());
                    FindUpgradesCommand.this.upgradedStreams.add(new Stream(artifact.getGroupId(), artifact.getArtifactId(), latestMicro.get()));
                }
            }
        }
    }

    private static interface UpgradeDiscoveryListener {
        public void upgrade(MavenArtifact var1, List<String> var2);
    }
}

