/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli.report;

import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.TrTag;
import j2html.tags.specialized.UlTag;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.logging.Logger;
import org.jboss.set.channel.cli.utils.VersionUtils;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.Repository;

public class FormattingReportBuilder {
    private static final Logger log = Logger.getLogger(FormattingReportBuilder.class);
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String BASIC_STYLES = "font-family: Verdana,sans-serif;font-size: 10pt;";
    private static final String BOLD_FONT = "font-weight: bold;";
    private static final String TABLE_STYLES = "margin: 2em 0;border-collapse: collapse;";
    private static final String CAPTION_STYLES = "text-align: left;font-weight: bold;";
    private static final String PADDING = "padding: 5px;";
    private static final String BORDER_TOP = "border-top: 1px solid #ddd;";
    private static final String TH_TD_STYLES = "padding: 5px;text-align: left;";
    private static final String GREY_TEXT = "color: #999;";
    private static final String SUBITEM_STYLES = "padding-left: 2em;color: #999;";
    private static final String GAV_STYLES = "font-family: \"Courier New\";";
    private static final String UL_STYLES = "list-style-type: circle;";
    private static final String LI_STYLES = "margin: 7px 0;";
    private static final String REPO_LABEL_STYLES = "border-radius: 5px;padding: 3px; margin-left: 1em;";
    private static final String BG1 = "background-color: #a8df65;";
    private static final String BG2 = "background-color: #edf492;";
    private static final String BG3 = "background-color: #efb960;";
    private static final String BG4 = "background-color: #ee91bc;";
    private static final String[] BACKGROUNDS = new String[]{"background-color: #a8df65;", "background-color: #edf492;", "background-color: #efb960;", "background-color: #ee91bc;"};
    private List<Repository> repositories;
    private List<String> repositoryIds = Collections.emptyList();
    private List<Pair<MavenArtifact, List<String>>> upgrades;
    private HashMap<MavenArtifact, Integer> aggregatedCounter;
    private Map<MavenArtifact, Map<String, String>> artifactsToRepositoryMap = Collections.emptyMap();

    public FormattingReportBuilder withRepositories(List<Repository> remoteRepositories) {
        this.repositories = remoteRepositories;
        this.repositoryIds = remoteRepositories.stream().map(Repository::getId).toList();
        return this;
    }

    public FormattingReportBuilder withUpgrades(List<Pair<MavenArtifact, List<String>>> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    public FormattingReportBuilder withArtifactToRepositoryMap(Map<MavenArtifact, Map<String, String>> artifactsToRepositoryMap) {
        this.artifactsToRepositoryMap = artifactsToRepositoryMap;
        return this;
    }

    public String build() {
        if (this.upgrades.isEmpty()) {
            log.info((Object)"No components to upgrade.");
            return null;
        }
        List<Pair<MavenArtifact, List<String>>> sortedUpgrades = this.upgrades.stream().sorted(AlphabeticalComparator.INSTANCE).toList();
        ArrayList<Pair<MavenArtifact, List<String>>> aggregatedUpgrades = new ArrayList<Pair<MavenArtifact, List<String>>>();
        this.aggregatedCounter = new HashMap();
        for (Pair<MavenArtifact, List<String>> pair : sortedUpgrades) {
            MavenArtifact a1 = (MavenArtifact)pair.getLeft();
            List versions = (List)pair.getRight();
            Optional<Pair> found = aggregatedUpgrades.stream().filter(p -> ((MavenArtifact)p.getLeft()).getGroupId().equals(a1.getGroupId()) && ((MavenArtifact)p.getLeft()).getVersion().equals(a1.getVersion()) && ((List)p.getRight()).containsAll(versions)).findAny();
            if (found.isEmpty()) {
                aggregatedUpgrades.add(pair);
                continue;
            }
            this.aggregatedCounter.compute((MavenArtifact)found.get().getLeft(), (a, i) -> {
                int n;
                if (i == null) {
                    n = 1;
                } else {
                    i = i + 1;
                    n = i;
                }
                return n;
            });
        }
        return ((DivTag)((DivTag)TagCreator.div().withStyle(BASIC_STYLES)).with(new DomContent[]{TagCreator.h2((String)"Component Upgrade Report"), TagCreator.p((String)"Following repositories were searched:"), ((UlTag)TagCreator.ul().withStyle(UL_STYLES)).with(TagCreator.each(this.repositories, entry -> ((LiTag)TagCreator.li().withStyle(LI_STYLES)).with(new DomContent[]{TagCreator.span((String)entry.getId()).withStyle(REPO_LABEL_STYLES + this.repositoryColor(entry.getId())), TagCreator.text((String)(" " + entry.getUrl()))}))), ((TableTag)TagCreator.table().withStyle("font-family: Verdana,sans-serif;font-size: 10pt;margin: 2em 0;border-collapse: collapse;")).with(new DomContent[]{TagCreator.caption((String)"Possible Component Upgrades").withStyle(CAPTION_STYLES), TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr().with(this.tableHeaders())}), TagCreator.each(aggregatedUpgrades, this::tableData), TagCreator.tr((DomContent[])new DomContent[]{((TdTag)TagCreator.td((String)(aggregatedUpgrades.size() + " items")).withStyle("padding: 5px;text-align: left;border-top: 1px solid #ddd;")).attr("colspan", (Object)"4")})}), TagCreator.p((String)("Generated on " + DATE_FORMATTER.format(ZonedDateTime.now())))})).render();
    }

    private DomContent[] tableHeaders() {
        ArrayList<Tag> headers = new ArrayList<Tag>();
        headers.add(TagCreator.th((String)"GAV").withStyle(TH_TD_STYLES));
        headers.add(TagCreator.th((String)"New Version").withStyle(TH_TD_STYLES));
        return headers.toArray(new DomContent[0]);
    }

    private DomContent tableData(Pair<MavenArtifact, List<String>> upgrade) {
        MavenArtifact artifact = (MavenArtifact)upgrade.getLeft();
        TbodyTag tbody = TagCreator.tbody();
        boolean first = true;
        for (String version : (List)upgrade.getRight()) {
            String repoId = (String)this.artifactsToRepositoryMap.getOrDefault(artifact, Collections.emptyMap()).get(version);
            ArrayList<Tag> cells = new ArrayList<Tag>();
            if (first) {
                cells.add(TagCreator.td((String)(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion())).withStyle("padding: 5px;font-family: \"Courier New\";"));
                cells.add(((TdTag)TagCreator.td().with(new DomContent[]{TagCreator.span((String)version).withStyle(VersionUtils.isTheSameMinor(artifact.getVersion(), version) ? BOLD_FONT : ""), repoId != null ? TagCreator.span((String)repoId).withStyle(REPO_LABEL_STYLES + this.repositoryColor(repoId)) : TagCreator.span()})).withStyle(PADDING));
            } else {
                cells.add(TagCreator.td((DomContent[])new DomContent[]{TagCreator.rawHtml((String)"&#8627;")}).withStyle(SUBITEM_STYLES));
                cells.add(((TdTag)TagCreator.td().with(new DomContent[]{TagCreator.span((String)version).withStyle(VersionUtils.isTheSameMinor(artifact.getVersion(), version) ? BOLD_FONT : ""), repoId != null ? TagCreator.span((String)repoId).withStyle(REPO_LABEL_STYLES + this.repositoryColor(repoId)) : TagCreator.span()})).withStyle(PADDING));
            }
            tbody.with((DomContent)((TrTag)TagCreator.tr().with(cells)).withStyle(BORDER_TOP));
            first = false;
        }
        Integer counter = this.aggregatedCounter.get(artifact);
        if (counter != null && counter > 0) {
            tbody.with((DomContent)TagCreator.tr().with((DomContent)TagCreator.td((String)(counter + " more artifacts from the same groupId")).withStyle(SUBITEM_STYLES)));
        }
        return tbody;
    }

    private String repositoryColor(String key) {
        int idx = this.repositoryIds.indexOf(key);
        return BACKGROUNDS[idx % BACKGROUNDS.length];
    }

    private static class AlphabeticalComparator
    implements Comparator<Pair<MavenArtifact, List<String>>> {
        static final AlphabeticalComparator INSTANCE = new AlphabeticalComparator();

        private AlphabeticalComparator() {
        }

        @Override
        public int compare(Pair<MavenArtifact, List<String>> u1, Pair<MavenArtifact, List<String>> u2) {
            int diff = ((MavenArtifact)u1.getLeft()).getGroupId().compareTo(((MavenArtifact)u2.getLeft()).getGroupId());
            if (diff == 0) {
                diff = ((MavenArtifact)u1.getLeft()).getArtifactId().compareTo(((MavenArtifact)u2.getLeft()).getArtifactId());
            }
            if (diff == 0) {
                diff = ((MavenArtifact)u1.getLeft()).getVersion().compareTo(((MavenArtifact)u2.getLeft()).getVersion());
            }
            return diff;
        }
    }
}

