/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Stream;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;

abstract class MavenBasedCommand
implements Callable<Integer> {
    protected static final Logger logger = Logger.getLogger(MavenBasedCommand.class);
    protected final RepositorySystem system;
    protected final DefaultRepositorySystemSession systemSession;

    public MavenBasedCommand() {
        try {
            this.system = MavenBasedCommand.newRepositorySystem();
            this.systemSession = MavenBasedCommand.newRepositorySystemSession(this.system);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize command", e);
        }
    }

    protected static Set<Stream> resolveStreams(List<Channel> channels, VersionResolverFactory resolverFactory) {
        List<ChannelManifestCoordinate> manifestCoordinates = channels.stream().map(Channel::getManifestCoordinate).toList();
        List repositories = channels.stream().flatMap(channel -> channel.getRepositories().stream()).toList();
        try (MavenVersionsResolver resolver = resolverFactory.create(repositories);){
            List resolvedBaseManifests = resolver.resolveChannelMetadata(manifestCoordinates);
            List<ChannelManifest> baseManifests = resolvedBaseManifests.stream().map(ChannelManifestMapper::from).toList();
            Set<Stream> set = baseManifests.stream().flatMap(manifest -> manifest.getStreams().stream()).collect(Collectors.toSet());
            return set;
        }
    }

    protected ChannelManifest resolveManifest(ChannelManifestCoordinate coordinate, List<Repository> repositories) {
        return ChannelManifestMapper.from((URL)this.resolveManifestUrl(coordinate, repositories));
    }

    protected URL resolveManifestUrl(ChannelManifestCoordinate coordinate, List<Repository> repositories) {
        try (VersionResolverFactory resolverFactory = new VersionResolverFactory(this.system, (RepositorySystemSession)this.systemSession);){
            URL uRL;
            block11: {
                MavenVersionsResolver resolver = resolverFactory.create(repositories);
                try {
                    List urls = resolver.resolveChannelMetadata(List.of(coordinate));
                    uRL = (URL)urls.get(0);
                    if (resolver == null) break block11;
                }
                catch (Throwable throwable) {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resolver.close();
            }
            return uRL;
        }
    }

    protected Channel resolveChannel(ChannelCoordinate coordinate, List<Repository> repositories) {
        try (VersionResolverFactory resolverFactory = new VersionResolverFactory(this.system, (RepositorySystemSession)this.systemSession);){
            Channel channel;
            block11: {
                MavenVersionsResolver resolver = resolverFactory.create(repositories);
                try {
                    List urls = resolver.resolveChannelMetadata(List.of(coordinate));
                    channel = ChannelMapper.from((URL)((URL)urls.get(0)));
                    if (resolver == null) break block11;
                }
                catch (Throwable throwable) {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resolver.close();
            }
            return channel;
        }
    }

    protected static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                logger.error((Object)"A Maven service creation failed", exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    protected static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) throws IOException {
        FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        Path localRepoPath = Files.createTempDirectory("local-maven-cache-", attrs);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoPath.toFile());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setChecksumPolicy("warn");
        return session;
    }
}

