/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.set.channel.cli.MavenBasedCommand;
import org.jboss.set.channel.cli.utils.ConversionUtils;
import org.jboss.set.channel.cli.utils.IOUtils;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="merge-manifests", description={"Merges two manifest. The second manifest streams always override the first manifest streams."})
public class MergeManifestsCommand
extends MavenBasedCommand {
    @CommandLine.Parameters(index="0", description={"First manifest coordinate (URL or GAV)"}, paramLabel="manifestCoordinate1")
    private String firstManifestCoordinateString;
    @CommandLine.Parameters(index="1", description={"Second manifest coordinate (URL or GAV)"}, paramLabel="manifestCoordinate2")
    private String secondManifestCoordinateString;
    @CommandLine.Option(names={"--manifest-repositories"}, split=",", description={"Comma separated repositories URLs where the manifest should be looked for, if they need to be resolved via maven."}, paramLabel="URL")
    private List<String> manifestRepositoriesUrls;
    @CommandLine.Option(names={"--output-file", "-o"}, defaultValue="manifest.yaml", description={"Manifest file to be written."})
    private Path outputFile;

    @Override
    public Integer call() throws Exception {
        ChannelManifestCoordinate firstCoordinate = ConversionUtils.toManifestCoordinate(this.firstManifestCoordinateString);
        ChannelManifestCoordinate secondCoordinate = ConversionUtils.toManifestCoordinate(this.secondManifestCoordinateString);
        if (firstCoordinate == null) {
            throw new IllegalArgumentException("Invalid coordinate: " + this.firstManifestCoordinateString);
        }
        if (secondCoordinate == null) {
            throw new IllegalArgumentException("Invalid coordinate: " + this.secondManifestCoordinateString);
        }
        List<Repository> repositories = ConversionUtils.toChannelRepositoryList(this.manifestRepositoriesUrls);
        ChannelManifest firstManifest = this.resolveManifest(firstCoordinate, repositories);
        ChannelManifest secondManifest = this.resolveManifest(secondCoordinate, repositories);
        Collection<Stream> mergedStreams = MergeManifestsCommand.mergeStreams(firstManifest.getStreams(), secondManifest.getStreams());
        IOUtils.writeManifestFile(this.outputFile, mergedStreams);
        return 0;
    }

    static Collection<Stream> mergeStreams(Collection<Stream> streams1, Collection<Stream> streams2) {
        LinkedHashMap firstMap = new LinkedHashMap();
        streams1.forEach(s -> firstMap.putIfAbsent(MergeManifestsCommand.key(s), s));
        LinkedHashMap secondMap = new LinkedHashMap();
        streams2.forEach(s -> secondMap.putIfAbsent(MergeManifestsCommand.key(s), s));
        LinkedHashMap mergedMap = new LinkedHashMap(firstMap);
        mergedMap.putAll(secondMap);
        return mergedMap.values();
    }

    private static String key(Stream s) {
        return s.getGroupId() + ":" + s.getArtifactId();
    }
}

