/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli.manifestbuilder;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.io.PomIO;
import org.jboss.logging.Logger;
import org.jboss.set.channel.cli.manifestbuilder.DependencyGroup;
import picocli.CommandLine;

@CommandLine.Command(name="generate-dependency-groups", description={"Generate dependency groups for validation purposes. (All dependencies in a group are expected to be of the same version.)"})
public class GenerateDependencyGroupsCommand
implements Callable<Integer> {
    protected static final Logger logger = Logger.getLogger(GenerateDependencyGroupsCommand.class);
    @CommandLine.Parameters(description={"Path(s) to the project pom file(s)"}, paramLabel="pomFile", arity="1..*")
    private File[] pomFiles;
    @CommandLine.Option(names={"-o", "--output-file"}, defaultValue="-")
    private File output;
    @CommandLine.Option(names={"-e", "--equivalent"}, arity="0..*", description={"prop1=prop2 pair meaning that group defined by a version property \"prop1\" should be merged into group defined by a version property \"prop2\"."})
    private String[] equivalents;
    private PomIO pomIO;
    private ManipulationSession session;
    private final Map<String, String> equivalencyMapping = new HashMap<String, String>();

    private void init() throws ComponentLookupException, PlexusContainerException {
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("on");
        config.setComponentVisibility("global");
        config.setName("Wildfly Channel CLI");
        DefaultPlexusContainer container = new DefaultPlexusContainer((ContainerConfiguration)config);
        this.pomIO = (PomIO)container.lookup(PomIO.class);
        this.session = (ManipulationSession)container.lookup(ManipulationSession.class);
        if (this.equivalents != null) {
            for (String option : this.equivalents) {
                String[] split = option.split("=");
                if (split.length != 2 || split[0].isBlank() || split[1].isBlank()) {
                    throw new IllegalArgumentException("Invalid equivalency option: " + option);
                }
                this.equivalencyMapping.put(split[0], split[1]);
            }
        }
    }

    @Override
    public Integer call() throws Exception {
        this.init();
        TreeMap<String, DependencyGroup> depsPerVersionProperty = new TreeMap<String, DependencyGroup>();
        for (File pomFile : this.pomFiles) {
            List projects = this.pomIO.parseProject(pomFile);
            for (Project project : projects) {
                DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
                if (dependencyManagement == null) continue;
                for (Dependency dep : dependencyManagement.getDependencies()) {
                    String artifactId;
                    String groupId = dep.getGroupId();
                    if (groupId.startsWith("${")) {
                        groupId = PropertyResolver.resolveInheritedProperties((MavenSessionHandler)this.session, (Project)project, (String)groupId);
                    }
                    if ((artifactId = dep.getArtifactId()).startsWith("${")) {
                        artifactId = PropertyResolver.resolveInheritedProperties((MavenSessionHandler)this.session, (Project)project, (String)artifactId);
                    }
                    if (!dep.getVersion().startsWith("${")) {
                        logger.errorf("Dependency %s:%s:%s does not use property version, group cannot be determined.", (Object)groupId, (Object)dep.getArtifactId(), (Object)dep.getVersion());
                        continue;
                    }
                    String versionProperty = dep.getVersion().substring(2, dep.getVersion().length() - 1);
                    String resolvedVersion = PropertyResolver.resolveInheritedProperties((MavenSessionHandler)this.session, (Project)project, (String)dep.getVersion());
                    String bucket = this.equivalencyMapping.getOrDefault(versionProperty, versionProperty);
                    DependencyGroup dependencyGroup = depsPerVersionProperty.computeIfAbsent(bucket, b -> new DependencyGroup(versionProperty));
                    dependencyGroup.getDependencies().add(groupId + ":" + artifactId + ":" + resolvedVersion);
                }
            }
        }
        YAMLMapper mapper = new YAMLMapper();
        if (this.output.getPath().equals("-")) {
            System.out.println(mapper.writeValueAsString(new ArrayList(depsPerVersionProperty.values())));
        } else {
            mapper.writeValue(this.output, new ArrayList(depsPerVersionProperty.values()));
        }
        return null;
    }
}

