/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.channel.cli.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public final class VersionUtils {
    private static final String DELIMITER_REGEX = "[-._]";

    private VersionUtils() {
    }

    public static String[] parseVersion(String version) {
        return version.split(DELIMITER_REGEX);
    }

    public static String[] numericalSegments(String[] segments) {
        for (int i = 0; i < segments.length; ++i) {
            try {
                Integer.valueOf(segments[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return Arrays.copyOf(segments, i);
            }
        }
        return segments;
    }

    public static String qualifier(String version) {
        String previousRemainder = version;
        while (true) {
            String[] segments = previousRemainder.split(DELIMITER_REGEX, 2);
            try {
                Integer.valueOf(segments[0]);
            }
            catch (NumberFormatException e) {
                return previousRemainder;
            }
            if (segments.length == 1) break;
            previousRemainder = segments[1];
        }
        return "";
    }

    public static String firstQualifierSegment(String[] segments) {
        for (String segment : segments) {
            try {
                Integer.valueOf(segment);
            }
            catch (NumberFormatException e) {
                return segment;
            }
        }
        return "";
    }

    public static String firstQualifierSegment(String version) {
        return VersionUtils.firstQualifierSegment(VersionUtils.parseVersion(version));
    }

    public static boolean isTheSameMinor(String v1, String v2) {
        String[] s1 = VersionUtils.parseVersion(v1);
        String[] s2 = VersionUtils.parseVersion(v2);
        for (int i = 0; i < 2; ++i) {
            if (i < s1.length && i < s2.length && s1[i].equals(s2[i])) continue;
            return false;
        }
        return true;
    }

    public static Optional<String> findMicroUpgrade(String baseVersion, Collection<String> upgradeVersions) {
        Optional<String> result = Optional.empty();
        for (String version : upgradeVersions) {
            if (!VersionUtils.isTheSameMinor(baseVersion, version)) continue;
            result = Optional.of(version);
        }
        return result;
    }
}

