/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.facade;

import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.factory.AbstractBeanFactory;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControllerBeanFactory
implements BeanFactory {
    private Controller controller;

    public ControllerBeanFactory(Controller controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    protected ControllerContext getInstalledContext(String name) {
        return this.controller.getInstalledContext((Object)name);
    }

    protected ControllerContext getContext(String name, ControllerState state) {
        return this.controller.getContext((Object)name, state);
    }

    public Object getBean(String name) throws BeansException {
        ControllerContext context = this.getInstalledContext(name);
        if (context == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return context.getTarget();
    }

    public Object getBean(String name, Class clazz) throws BeansException {
        if (clazz == null) {
            return this.getBean(name);
        }
        return this.getBeanWithType(name, clazz);
    }

    protected <T> T getBeanWithType(String name, Class<T> clazz) throws BeansException {
        Object result = this.getBean(name);
        if (!clazz.isInstance(result)) {
            throw new BeanNotOfRequiredTypeException(name, clazz, result.getClass());
        }
        return clazz.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name, Object[] parameters) throws BeansException {
        AbstractBeanFactory result = this.getBeanWithType(name, AbstractBeanFactory.class);
        ConstructorMetaData cmd = result.getConstructor();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Temp");
        for (Object parameter : parameters) {
            builder.addConstructorParameter(null, parameter);
        }
        ConstructorMetaData tempCMD = builder.getBeanMetaData().getConstructor();
        AbstractBeanFactory abstractBeanFactory = result;
        synchronized (abstractBeanFactory) {
            Object object;
            result.setConstructor(tempCMD);
            try {
                object = this.createBean(result);
            }
            catch (Throwable throwable) {
                result.setConstructor(cmd);
                throw throwable;
            }
            result.setConstructor(cmd);
            return object;
        }
    }

    public boolean containsBean(String name) {
        return this.getInstalledContext(name) != null;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return !this.isPrototype(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        Object result = this.getBean(name);
        return this.isPrototype(result);
    }

    protected boolean isPrototype(Object result) {
        return org.jboss.beans.metadata.spi.factory.BeanFactory.class.isInstance(result);
    }

    protected Object createBean(Object factory) throws BeansException {
        try {
            return ((org.jboss.beans.metadata.spi.factory.BeanFactory)org.jboss.beans.metadata.spi.factory.BeanFactory.class.cast(factory)).createBean();
        }
        catch (Throwable t) {
            throw new FatalBeanException("Cannot create bean: " + factory, t);
        }
    }

    public boolean isTypeMatch(String name, Class clazz) throws NoSuchBeanDefinitionException {
        return clazz.isInstance(this.getBean(name));
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        ControllerContext context = this.getContext(name, ControllerState.DESCRIBED);
        if (context == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        if (context instanceof KernelControllerContext) {
            KernelControllerContext kcc = (KernelControllerContext)context;
            BeanInfo beanInfo = kcc.getBeanInfo();
            ClassInfo classInfo = beanInfo.getClassInfo();
            TypeInfoFactory tif = classInfo.getTypeInfoFactory();
            if (tif.getTypeInfo(AbstractBeanFactory.class).isAssignableFrom((TypeInfo)classInfo)) {
                return this.getPrototypeClass((ControllerContext)kcc);
            }
            return classInfo.getType();
        }
        return null;
    }

    protected Class<?> getPrototypeClass(ControllerContext cc) {
        if (!(cc instanceof KernelControllerContext)) {
            return null;
        }
        KernelControllerContext kcc = (KernelControllerContext)cc;
        BeanMetaData bmd = kcc.getBeanMetaData();
        Set properties = bmd.getProperties();
        for (PropertyMetaData pmd : properties) {
            if (!"bean".equals(pmd.getName())) continue;
            ValueMetaData value = pmd.getValue();
            if (value != null && value.getUnderlyingValue() != null) {
                String className = value.getUnderlyingValue().toString();
                return this.getBeanClass(className, kcc);
            }
            return null;
        }
        return null;
    }

    protected Class<?> getBeanClass(String className, KernelControllerContext context) throws BeansException {
        try {
            ClassLoader cl = context.getClassLoader();
            return cl.loadClass(className);
        }
        catch (Throwable t) {
            throw new FatalBeanException("Cannot load class: " + className + ", context: " + context, t);
        }
    }

    public String[] getAliases(String name) {
        ControllerContext context = this.getContext(name, null);
        if (context == null || context.getAliases() == null) {
            return new String[0];
        }
        Set aliases = context.getAliases();
        String[] result = new String[aliases.size()];
        int i = 0;
        for (Object alias : aliases) {
            result[i++] = alias.toString();
        }
        return result;
    }
}

