/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.spring.vfs.VFSUtil;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class VFSResource
extends AbstractResource {
    private Object file;

    public VFSResource(Object file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    public VFSResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            this.file = VFSUtil.invokeVfsMethod(VFSUtil.VFS_METHOD_GET_ROOT_URL, null, url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot retrieve file from URL: ", e);
        }
    }

    public boolean exists() {
        try {
            return (Boolean)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_EXISTS, this.file, new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isReadable() {
        try {
            return (Long)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_SIZE, this.file, new Object[0]) > 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long lastModified() {
        try {
            return (Long)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED, this.file, new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getURL() throws IOException {
        return (URL)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_TO_URL, this.file, new Object[0]);
    }

    public URI getURI() throws IOException {
        try {
            return (URI)VFSUtil.invokeMethodWithExpectedExceptionType(VFSUtil.VIRTUAL_FILE_METHOD_TO_URI, this.file, URISyntaxException.class, new Object[0]);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public File getFile() throws IOException {
        return VFSUtil.getPhysicalFile(this.file);
    }

    public Resource createRelative(String relativePath) throws IOException {
        if (relativePath.startsWith(".") || relativePath.indexOf("/") == -1) {
            return new VFSResource(VFSResource.getChild(new URL(this.getURL(), relativePath)));
        }
        return new VFSResource(VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_CHILD, this.file, relativePath));
    }

    public String getFilename() {
        try {
            return (String)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_NAME, this.file, new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return this.file.toString();
    }

    public InputStream getInputStream() throws IOException {
        return (InputStream)VFSUtil.invokeVfsMethod(VFSUtil.VIRTUAL_FILE_METHOD_GET_INPUT_STREAM, this.file, new Object[0]);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object other) {
        if (other instanceof VFSResource) {
            return this.file.equals(((VFSResource)((Object)other)).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    static Object getChild(URL url) throws IOException {
        try {
            return VFSUtil.invokeMethodWithExpectedExceptionType(VFSUtil.VFS_METHOD_GET_ROOT_URL, null, URISyntaxException.class, url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

