/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchDog<T, C extends Observer>
implements Runnable {
    public static final long DEFAULT_DELAY = 30000L;
    final Log log = LogFactory.getLog(WatchDog.class);
    private long expire;
    private T lastModif;
    private long delay = 30000L;
    private boolean existedBefore;
    private boolean warnedAlready;
    private boolean interrupted;
    protected Mutable<T> mutable;
    protected C observer;

    public WatchDog() {
    }

    public WatchDog(Mutable<T> mutable, long delay) {
        this(mutable);
        this.delay = delay;
    }

    public WatchDog(Mutable<T> mutable, C observer) {
        this.mutable = mutable;
        this.observer = observer;
    }

    public WatchDog(Mutable<T> mutable) {
        this.mutable = mutable;
    }

    public Mutable<T> getMutable() {
        return this.mutable;
    }

    public C getObserver() {
        return this.observer;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public void run() {
        try {
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.check();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Exception occured. Thread will stop", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void check() {
        long now = System.currentTimeMillis();
        if (this.expire <= now) {
            this.observer.getLock().lock();
            this.expire = now + this.delay;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[" + this.mutable + "]" + " check for changes"));
                }
                if (this.mutable.exists()) {
                    this.existedBefore = true;
                    if (this.lastModif == null || this.mutable.hasChangedSince(this.lastModif)) {
                        this.lastModif = this.mutable.lastModified();
                        this.observer.onUpdate();
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("[" + this.mutable + "]" + " updated"));
                        }
                        this.warnedAlready = false;
                        return;
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("[" + this.mutable + "]" + " has not changed"));
                    return;
                }
                if (!this.observer.isInitialized()) {
                    this.observer.init();
                    if (!this.log.isInfoEnabled()) return;
                    this.log.info((Object)("[" + this.mutable + "]" + " initialized"));
                    return;
                }
                if (this.existedBefore) {
                    this.existedBefore = false;
                    this.lastModif = null;
                    this.observer.onDelete();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("[" + this.mutable + "]" + " deleted"));
                    }
                }
                if (this.warnedAlready) return;
                this.warnedAlready = true;
                if (!this.log.isInfoEnabled()) return;
                this.log.info((Object)("[" + this.mutable + "]" + " does not exist."));
                return;
            }
            finally {
                this.observer.getLock().unlock();
            }
        } else {
            if (!this.log.isTraceEnabled()) return;
            this.log.trace((Object)("[" + this.mutable + "]" + " wait period is not over"));
        }
    }

    public static <C extends Observer> WatchDog<Long, C> watchFile(File file, C handler) {
        return new WatchDog<Long, C>(new FileMutable(file), handler);
    }

    public static <C extends Observer> WatchDog<Map<File, Long>, C> watchFiles(List<File> files, C handler) {
        return new WatchDog<Map<File, Long>, C>(new FileSetMutable(files), handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultObserver<A>
    implements Observer<A> {
        protected final ReadWriteLock lock = new ReentrantReadWriteLock();
        protected A object;

        @Override
        public boolean isInitialized() {
            return this.object != null;
        }

        @Override
        public void init() {
        }

        @Override
        public void onDelete() {
            this.init();
        }

        @Override
        public void onUpdate() {
            this.init();
        }

        @Override
        public Lock getLock() {
            return this.lock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public A get() {
            this.lock.readLock().lock();
            try {
                A a = this.object;
                return a;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Observer<A> {
        public boolean isInitialized();

        public void init();

        public void onDelete();

        public void onUpdate();

        public Lock getLock();

        public A get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileSetMutable
    implements Mutable<Map<File, Long>> {
        File[] files;

        public FileSetMutable(Collection<File> files) {
            this.files = new File[files.size()];
            files.toArray(this.files);
        }

        public FileSetMutable(File[] files) {
            this.files = files;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean hasChangedSince(Map<File, Long> since) {
            Object snapshot = this.lastModified();
            return !CollectionUtils.equals((Map)snapshot, since);
        }

        @Override
        public Map<File, Long> lastModified() {
            HashMap<File, Long> m = new HashMap<File, Long>(this.files.length * 15 / 10);
            for (File f : this.files) {
                m.put(f, f.lastModified());
            }
            return m;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileMutable
    implements Mutable<Long> {
        File file;

        public FileMutable(File file) {
            this.file = file;
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public boolean hasChangedSince(Long since) {
            return this.lastModified().longValue() != since.longValue();
        }

        @Override
        public Long lastModified() {
            return this.file.lastModified();
        }

        public String toString() {
            return this.file.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mutable<T> {
        public boolean exists();

        public boolean hasChangedSince(T var1);

        public T lastModified();
    }
}

