/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.sax;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.msg.CommonMessages;
import org.apache.ode.utils.msg.MessageBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final Log __log = LogFactory.getLog(LoggingErrorHandler.class);
    private Log _l;
    private static final String WARNING = MessageBundle.getMessages(CommonMessages.class).strWarning().toUpperCase();
    private static final String ERROR = MessageBundle.getMessages(CommonMessages.class).strError().toUpperCase();
    private static final String FATAL = MessageBundle.getMessages(CommonMessages.class).strFatal().toUpperCase();

    public LoggingErrorHandler() {
        this._l = __log;
    }

    public LoggingErrorHandler(Log log) {
        this._l = log;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this._l.isDebugEnabled()) {
            this._l.debug((Object)this.formatMessage(WARNING, exception));
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this._l.isDebugEnabled()) {
            this._l.debug((Object)this.formatMessage(ERROR, exception));
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this._l.isDebugEnabled()) {
            this._l.debug((Object)this.formatMessage(FATAL, exception));
        }
    }

    private String formatMessage(String level, SAXParseException spe) {
        StringBuffer sb = new StringBuffer(64);
        if (spe.getSystemId() != null) {
            sb.append(spe.getSystemId());
        }
        sb.append(':');
        sb.append(spe.getLineNumber());
        sb.append(':');
        sb.append(spe.getColumnNumber());
        sb.append(':');
        sb.append(level);
        sb.append(':');
        sb.append(spe.getMessage());
        return sb.toString();
    }
}

