/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelImpl
implements SchemaModel {
    private static final Log __log = LogFactory.getLog(SchemaModelImpl.class);
    private XSModel _model;

    private SchemaModelImpl(XSModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Null model.");
        }
        this._model = model;
    }

    public static final SchemaModel newModel(Map<URI, byte[]> schemas) {
        XMLSchemaLoader schemaLoader = new XMLSchemaLoader();
        InternalSchemaResolver resolver = new InternalSchemaResolver();
        schemaLoader.setEntityResolver((XMLEntityResolver)resolver);
        schemaLoader.setParameter("error-handler", (Object)new SchemaErrorHandler());
        final String[] uris = new String[schemas.size()];
        final byte[][] content = new byte[schemas.size()][];
        int idx = 0;
        for (Map.Entry<URI, byte[]> me : schemas.entrySet()) {
            uris[idx] = me.getKey().toASCIIString();
            content[idx] = me.getValue();
            resolver.put(me.getKey(), me.getValue());
            ++idx;
        }
        LSInputList list = new LSInputList(){

            public LSInput item(int index) {
                DOMInputImpl input = new DOMInputImpl();
                input.setSystemId(uris[index]);
                input.setByteStream((InputStream)new ByteArrayInputStream(content[index]));
                return input;
            }

            public int getLength() {
                return uris.length;
            }
        };
        XSModel xsm = schemaLoader.loadInputList(list);
        return new SchemaModelImpl(xsm);
    }

    @Override
    public boolean isCompatible(QName type1, QName type2) {
        XSTypeDefinition typeDef2;
        XSTypeDefinition typeDef1;
        if (this.knowsElementType(type1)) {
            typeDef1 = this._model.getElementDeclaration(type1.getLocalPart(), type1.getNamespaceURI()).getTypeDefinition();
        } else if (this.knowsSchemaType(type1)) {
            typeDef1 = this._model.getTypeDefinition(type1.getLocalPart(), type1.getNamespaceURI());
        } else {
            throw new IllegalArgumentException("unknown schema type: " + type1);
        }
        if (this.knowsElementType(type2)) {
            typeDef2 = this._model.getElementDeclaration(type2.getLocalPart(), type2.getNamespaceURI()).getTypeDefinition();
        } else if (this.knowsSchemaType(type2)) {
            typeDef2 = this._model.getTypeDefinition(type2.getLocalPart(), type2.getNamespaceURI());
        } else {
            throw new IllegalArgumentException("unknown schema type: " + type2);
        }
        return typeDef1.derivedFromType(typeDef2, (short)0) || typeDef2.derivedFromType(typeDef1, (short)0);
    }

    @Override
    public boolean isSimpleType(QName type) {
        if (type == null) {
            throw new NullPointerException("Null type argument!");
        }
        XSTypeDefinition typeDef = this._model.getTypeDefinition(type.getLocalPart(), type.getNamespaceURI());
        return typeDef != null && typeDef.getTypeCategory() == 16;
    }

    @Override
    public boolean knowsElementType(QName elementType) {
        if (elementType == null) {
            throw new NullPointerException("Null type argument!");
        }
        return this._model.getElementDeclaration(elementType.getLocalPart(), elementType.getNamespaceURI()) != null;
    }

    @Override
    public boolean knowsSchemaType(QName schemaType) {
        if (schemaType == null) {
            throw new NullPointerException("Null type argument!");
        }
        return this._model.getTypeDefinition(schemaType.getLocalPart(), schemaType.getNamespaceURI()) != null;
    }

    public static class InternalSchemaResolver
    implements XMLEntityResolver {
        private Map<String, byte[]> _schemas = new HashMap<String, byte[]>();

        public void put(URI uri, byte[] bytes) {
            this._schemas.put(uri.toASCIIString(), bytes);
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
            XMLInputSource src = new XMLInputSource(resourceIdentifier);
            String location = "";
            if (resourceIdentifier.getNamespace() != null && this._schemas.get(resourceIdentifier.getNamespace()) != null) {
                location = resourceIdentifier.getNamespace();
            } else if (resourceIdentifier.getLiteralSystemId() != null && this._schemas.get(resourceIdentifier.getLiteralSystemId()) != null) {
                location = resourceIdentifier.getLiteralSystemId();
            } else if (resourceIdentifier.getBaseSystemId() != null && this._schemas.get(resourceIdentifier.getBaseSystemId()) != null) {
                location = resourceIdentifier.getBaseSystemId();
            }
            src.setByteStream((InputStream)new ByteArrayInputStream(this._schemas.get(location)));
            return src;
        }
    }

    private static class SchemaErrorHandler
    implements DOMErrorHandler {
        private SchemaErrorHandler() {
        }

        public boolean handleError(DOMError error) {
            boolean isWarning = error.getSeverity() == 1;
            __log.warn((Object)"Schema error", (Throwable)((Exception)error.getRelatedException()));
            __log.warn((Object)(error.getLocation().getUri() + ":" + error.getLocation().getLineNumber()));
            __log.warn(error.getRelatedData());
            __log.warn(error.getRelatedException());
            return isWarning;
        }
    }
}

