/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.o;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPartnerLink
extends OBase {
    static final long serialVersionUID = -1L;
    public String name;
    public OScope declaringScope;
    public QName partnerLinkType;
    public String partnerRoleName;
    public String myRoleName;
    public PortType myRolePortType;
    public PortType partnerRolePortType;
    public boolean initializePartnerRole;
    private final HashMap<String, Set<OScope.CorrelationSet>> _nonIntitiatingCorrelationSets = new HashMap();
    private HashMap<String, Set<OScope.CorrelationSet>> _joiningCorrelationSets = new HashMap();
    private final HashSet<String> _createInstanceOperations = new HashSet();

    public OPartnerLink(OProcess owner) {
        super(owner);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasMyRole() {
        return this.myRolePortType != null;
    }

    public boolean hasPartnerRole() {
        return this.partnerRolePortType != null;
    }

    public boolean isCreateInstanceOperation(Operation op) {
        return this._createInstanceOperations.contains(op.getName());
    }

    public void addCreateInstanceOperation(Operation operation) {
        this._createInstanceOperations.add(operation.getName());
    }

    public void addCorrelationSetForOperation(Operation operation, OScope.CorrelationSet cset, boolean isJoin) {
        if (!isJoin) {
            Set<OScope.CorrelationSet> ret = this._nonIntitiatingCorrelationSets.get(operation.getName());
            if (ret == null) {
                ret = new HashSet<OScope.CorrelationSet>();
                this._nonIntitiatingCorrelationSets.put(operation.getName(), ret);
            }
            ret.add(cset);
        } else {
            Set<OScope.CorrelationSet> ret;
            if (this._joiningCorrelationSets == null) {
                this._joiningCorrelationSets = new HashMap();
            }
            if ((ret = this._joiningCorrelationSets.get(operation.getName())) == null) {
                ret = new HashSet<OScope.CorrelationSet>();
                this._joiningCorrelationSets.put(operation.getName(), ret);
            }
            ret.add(cset);
        }
    }

    public Set<OScope.CorrelationSet> getNonInitiatingCorrelationSetsForOperation(Operation operation) {
        Set<OScope.CorrelationSet> ret = this._nonIntitiatingCorrelationSets.get(operation.getName());
        if (ret == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<OScope.CorrelationSet> getJoinningCorrelationSetsForOperation(Operation operation) {
        if (this._joiningCorrelationSets == null) {
            return new HashSet<OScope.CorrelationSet>();
        }
        Set<OScope.CorrelationSet> ret = this._joiningCorrelationSets.get(operation.getName());
        if (ret == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(ret);
    }

    public Operation getMyRoleOperation(String name) {
        for (Operation op : this.myRolePortType.getOperations()) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    public Operation getPartnerRoleOperation(String name) {
        for (Operation op : this.partnerRolePortType.getOperations()) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OPartnerLink)) {
            return false;
        }
        OPartnerLink other = (OPartnerLink)obj;
        return this.name == null && other.name == null && super.equals(obj) || this.name.equals(other.name);
    }
}

