/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class Axis2WSDLLocator
implements WSDLLocator {
    private static final Log LOG = LogFactory.getLog(Axis2WSDLLocator.class);
    private URI _baseUri;
    private String _latest;

    public Axis2WSDLLocator(URI baseUri) throws URISyntaxException {
        this._baseUri = baseUri;
    }

    public InputSource getBaseInputSource() {
        try {
            InputSource is = new InputSource();
            is.setByteStream(this.openResource(this._baseUri));
            is.setSystemId(this._baseUri.toString());
            return is;
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to create InputSource for " + this._baseUri), (Throwable)e);
            return null;
        }
    }

    public InputSource getImportInputSource(String parent, String imprt) {
        URI uri;
        try {
            uri = parent == null ? this._baseUri.resolve(imprt) : new URI(parent).resolve(imprt);
        }
        catch (URISyntaxException e1) {
            LOG.error((Object)("URI syntax error: parent=" + parent + " error=" + e1));
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get import:  import=" + imprt + " parent=" + parent));
        }
        InputSource is = new InputSource();
        try {
            is.setByteStream(this.openResource(uri));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to open import resource: " + uri), (Throwable)e);
            return null;
        }
        is.setSystemId(uri.toString());
        this._latest = uri.toString();
        return is;
    }

    public String getBaseURI() {
        return this._baseUri.toString();
    }

    public String getLatestImportURI() {
        return this._latest;
    }

    public void close() {
    }

    public InputStream openResource(URI uri) throws IOException {
        if (uri.isAbsolute() && uri.getScheme().equals("file")) {
            try {
                return uri.toURL().openStream();
            }
            catch (Exception except) {
                LOG.error((Object)("openResource: unable to open file URL " + uri + "; " + except.toString()));
                return null;
            }
        }
        URI relative = this._baseUri.relativize(uri);
        if (relative.isAbsolute() && !relative.getScheme().equals("urn")) {
            LOG.error((Object)("openResource: invalid scheme (should be urn:)  " + uri));
            return null;
        }
        File f = new File(this._baseUri.getPath(), relative.getPath());
        if (!f.exists()) {
            LOG.error((Object)("openResource: file not found " + f));
            return null;
        }
        return new FileInputStream(f);
    }
}

