/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpParams;

public class ProxyConf {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";

    public static void configure(HostConfiguration hostConfig, HttpState state, HttpTransportProperties.ProxyProperties proxyProperties) {
        String port;
        String proxyHost = proxyProperties.getProxyHostName();
        int proxyPort = proxyProperties.getProxyPort();
        String userName = proxyProperties.getUserName();
        String password = proxyProperties.getPassWord();
        String domain = proxyProperties.getDomain();
        Object proxyCred = userName != null && password != null && domain != null ? new NTCredentials(userName, password, proxyHost, domain) : (userName != null ? new UsernamePasswordCredentials(userName, password) : new UsernamePasswordCredentials("", ""));
        String host = System.getProperty(HTTP_PROXY_HOST);
        if (host != null) {
            proxyHost = host;
            proxyCred = new UsernamePasswordCredentials("", "");
        }
        if ((port = System.getProperty(HTTP_PROXY_PORT)) != null) {
            proxyPort = Integer.parseInt(port);
        }
        state.setProxyCredentials(AuthScope.ANY, (Credentials)proxyCred);
        hostConfig.setProxy(proxyHost, proxyPort);
    }

    public static boolean isProxyEnabled(HttpParams params, String targetHost) throws URIException {
        boolean isSet = params.isParameterSet("http.proxy.");
        boolean bl = System.getProperty(HTTP_PROXY_HOST) != null;
        boolean isNonProxyHost = ProxyConf.isNonProxyHost(targetHost);
        return (isSet |= bl) && !isNonProxyHost;
    }

    public static boolean isNonProxyHost(String targetHost) {
        String nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (nonProxyHosts != null) {
            String[] splitted = nonProxyHosts.split("\\|");
            for (int i = 0; i < splitted.length; ++i) {
                if (!targetHost.matches(splitted[i])) continue;
                return true;
            }
        }
        return false;
    }
}

