/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.dbutil;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.impl.io.VFMemoryStorageFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.il.dbutil.DatabaseConnectionManager;
import org.apache.ode.il.dbutil.EmbeddedDatabase;

public class DerbyDatabase
implements EmbeddedDatabase {
    private static final Log __log = LogFactory.getLog(DerbyDatabase.class);
    private DatabaseConnectionManager _connectionManager;
    private String _dbUrl = null;
    private DataSource _dataSource = null;
    private File _workRoot = null;
    private String _dbName = null;

    public void init(File workRoot, OdeConfigProperties props, TransactionManager txm) {
        this._workRoot = workRoot;
        this._dbName = props.getDbEmbeddedName();
        if (this._workRoot == null) {
            this._dbUrl = "jdbc:derby:memory:" + this._dbName + ";create=true";
            try {
                DriverManager.getConnection(this._dbUrl).close();
            }
            catch (SQLException se) {
                __log.error((Object)se);
            }
            EmbeddedDataSource dds = new EmbeddedDataSource();
            dds.setDatabaseName("memory:" + this._dbName);
            dds.setUser("sa");
            dds.setCreateDatabase("true");
            this._dataSource = dds;
        } else {
            this._dbUrl = "jdbc:derby:" + this._workRoot + File.separator + this._dbName;
            if (props.isDbEmbeddedCreate()) {
                this._dbUrl = this._dbUrl + ";create=true";
            }
            String clazz = EmbeddedDriver.class.getName();
            this._connectionManager = new DatabaseConnectionManager(txm, props);
            try {
                this._connectionManager.init(this._dbUrl, clazz, "sa", null);
            }
            catch (DatabaseConfigException ex) {
                __log.error((Object)"Unable to initialize connection pool", (Throwable)ex);
            }
            this._dataSource = this._connectionManager.getDataSource();
            __log.debug((Object)("Using Embedded Database: " + this._dbUrl));
        }
    }

    public void shutdown() {
        if (this._connectionManager != null) {
            try {
                this._connectionManager.shutdown();
            }
            catch (DatabaseConfigException ex) {
                __log.error((Object)"unable to shutdown connection pool", (Throwable)ex);
            }
        }
        try {
            DriverManager.getConnection(this._dbUrl + ";shutdown=true").close();
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() != 45000) {
                __log.error((Object)("Error shutting down Derby: " + ex.getErrorCode()), (Throwable)ex);
            }
        }
        catch (Throwable ex) {
            __log.debug((Object)"Error shutting down Derby.", ex);
        }
        if (this._workRoot == null) {
            try {
                VFMemoryStorageFactory.purgeDatabase((String)new File(this._dbName).getCanonicalPath());
            }
            catch (Exception e) {
                __log.debug((Object)"Error shutting down Derby.", (Throwable)e);
            }
        }
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }
}

